/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.json.common.base.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableJsonSerializer
extends JsonSerializer<Pageable> {
    public void serialize(Pageable pageable, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (pageable == null) {
            return;
        }
        gen.writeStartObject();
        gen.writeNumberField("pageNumber", pageable.getPageNumber());
        gen.writeNumberField("pageSize", pageable.getPageSize());
        Sort sort = pageable.getSort();
        if (sort != null) {
            gen.writeFieldName("sort");
            gen.writeStartArray();
            for (Sort.Order order : sort) {
                gen.writeStartObject();
                gen.writeStringField("property", order.getProperty());
                gen.writeStringField("direction", order.getDirection().toString());
                gen.writeEndObject();
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }
}

