/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.logging.common.impl;

import com.devonfw.module.logging.common.api.DiagnosticContextFacade;
import com.devonfw.module.logging.common.impl.DiagnosticContextFacadeImpl;
import java.io.IOException;
import java.util.UUID;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DiagnosticContextFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(DiagnosticContextFilter.class);
    private static final String CORRELATION_ID_HEADER_NAME_PARAM = "correlationIdHeaderName";
    public static final String CORRELATION_ID_HEADER_NAME_DEFAULT = "X-Correlation-Id";
    private String correlationIdHttpHeaderName = "X-Correlation-Id";
    private DiagnosticContextFacade diagnosticContextFacade;

    public void setCorrelationIdHttpHeaderName(String correlationIdHttpHeaderName) {
        this.correlationIdHttpHeaderName = correlationIdHttpHeaderName;
    }

    public void destroy() {
    }

    private static String normalizeValue(String value) {
        String result;
        if (value != null && !(result = value.trim()).isEmpty()) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.setCorrelationId(request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.diagnosticContextFacade.removeCorrelationId();
        }
    }

    private void setCorrelationId(ServletRequest request) {
        String correlationId = null;
        if (request instanceof HttpServletRequest && this.correlationIdHttpHeaderName != null) {
            correlationId = DiagnosticContextFilter.normalizeValue(((HttpServletRequest)request).getHeader(this.correlationIdHttpHeaderName));
            if (correlationId == null) {
                LOG.debug("No correlation ID found for HTTP header {}.", (Object)this.correlationIdHttpHeaderName);
            } else {
                this.diagnosticContextFacade.setCorrelationId(correlationId);
                LOG.debug("Using correlation ID {} from HTTP header {}.", (Object)correlationId, (Object)this.correlationIdHttpHeaderName);
                return;
            }
        }
        if (correlationId == null) {
            correlationId = DiagnosticContextFilter.normalizeValue(this.diagnosticContextFacade.getCorrelationId());
            if (correlationId != null) {
                LOG.debug("Correlation ID was already set to {} before DiagnosticContextFilter has been invoked.", (Object)correlationId);
            } else {
                correlationId = UUID.randomUUID().toString();
                this.diagnosticContextFacade.setCorrelationId(correlationId);
                LOG.debug("Created unique correlation ID {}.", (Object)correlationId);
            }
        }
    }

    @Inject
    public void setDiagnosticContextFacade(DiagnosticContextFacade diagnosticContextFacade) {
        this.diagnosticContextFacade = diagnosticContextFacade;
    }

    public void init(FilterConfig config) throws ServletException {
        String headerName = config.getInitParameter(CORRELATION_ID_HEADER_NAME_PARAM);
        if (headerName == null) {
            LOG.debug("Parameter {} not configured via filter config.", (Object)CORRELATION_ID_HEADER_NAME_PARAM);
        } else {
            this.correlationIdHttpHeaderName = headerName;
        }
        LOG.info("Correlation ID header initialized to: {}", (Object)this.correlationIdHttpHeaderName);
        if (this.diagnosticContextFacade == null) {
            try {
                ServletContext servletContext = config.getServletContext();
                WebApplicationContext springContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
                this.diagnosticContextFacade = (DiagnosticContextFacade)springContext.getBean(DiagnosticContextFacade.class);
            }
            catch (Throwable e) {
                LOG.warn("DiagnosticContextFacade not defined in spring. Falling back to default", e);
                this.diagnosticContextFacade = new DiagnosticContextFacadeImpl();
            }
        }
    }
}

