/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.logging.common.impl;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SecureLogging {
    private static final Logger LOG = LoggerFactory.getLogger(SecureLogging.class);
    private static final String EXT_CLASS = "org.owasp.security.logging.SecurityMarkers";
    private static final String METHOD_NAME = "getMarker";
    private static boolean initialized = false;
    private static Marker markerSecurSuccConfid = null;
    private static Marker markerSecurFailConfid = null;
    private static Marker markerSecurAuditConfid = null;
    private static final String RESTRICTED_MARKER_NAME = "RESTRICTED";
    private static final String CONFIDENTIAL_MARKER_NAME = "CONFIDENTIAL";
    private static final String SECURITY_SUCCESS_MARKER_NAME = "SECURITY SUCCESS";
    private static final String SECURITY_FAILURE_MARKER_NAME = "SECURITY FAILURE";
    private static final String SECURITY_AUDIT_MARKER_NAME = "SECURITY AUDIT";
    private static final String SECURITY_SUCCESS_CONFIDENTIAL_MARKER_NAME = "SECURITY SUCCESSCONFIDENTIAL";
    private static final String SECURITY_FAILURE_CONFIDENTIAL_MARKER_NAME = "SECURITY FAILURECONFIDENTIAL";
    private static final String SECURITY_AUDIT_CONFIDENTIAL_MARKER_NAME = "SECURITY AUDITCONFIDENTIAL";
    public static final Marker RESTRICTED = MarkerFactory.getDetachedMarker((String)"RESTRICTED");
    public static final Marker CONFIDENTIAL = MarkerFactory.getDetachedMarker((String)"CONFIDENTIAL");
    public static final Marker SECURITY_SUCCESS = MarkerFactory.getDetachedMarker((String)"SECURITY SUCCESS");
    public static final Marker SECURITY_FAILURE = MarkerFactory.getDetachedMarker((String)"SECURITY FAILURE");
    public static final Marker SECURITY_SUCCESS_CONFIDENTIAL = SecureLogging.getMarkerSecurSuccConfid();
    public static final Marker SECURITY_FAILURE_CONFIDENTIAL = SecureLogging.getMarkerSecurFailConfid();
    public static final Marker SECURITY_AUDIT_CONFIDENTIAL = SecureLogging.getMarkerSecurAuditConfid();

    private SecureLogging() {
    }

    private static Marker getMarkerSecurSuccConfid() {
        SecureLogging.initMarkers();
        return markerSecurSuccConfid;
    }

    private static Marker getMarkerSecurFailConfid() {
        SecureLogging.initMarkers();
        return markerSecurFailConfid;
    }

    private static Marker getMarkerSecurAuditConfid() {
        SecureLogging.initMarkers();
        return markerSecurAuditConfid;
    }

    private static void initMarkers() {
        if (initialized) {
            return;
        }
        Class<String> cExtClass = SecureLogging.findExtClass(EXT_CLASS);
        if (cExtClass.isAssignableFrom(String.class)) {
            SecureLogging.createDefaultMarkers();
        } else {
            SecureLogging.createMultiMarkers(cExtClass);
        }
        if (!initialized) {
            LOG.warn("SecureLogging Markers could not be initialized!");
        } else {
            LOG.debug("SecureLogging Markers created: '{}', ...", (Object)markerSecurSuccConfid.getName());
        }
    }

    private static void createDefaultMarkers() {
        LOG.debug("Creating default markers.");
        markerSecurSuccConfid = MarkerFactory.getDetachedMarker((String)SECURITY_SUCCESS_CONFIDENTIAL_MARKER_NAME);
        markerSecurFailConfid = MarkerFactory.getDetachedMarker((String)SECURITY_FAILURE_CONFIDENTIAL_MARKER_NAME);
        markerSecurAuditConfid = MarkerFactory.getDetachedMarker((String)SECURITY_AUDIT_CONFIDENTIAL_MARKER_NAME);
        initialized = true;
    }

    private static void createMultiMarkers(Class<?> cExtClass) {
        LOG.debug("Creating MultiMarkers.");
        Object objExtClass = null;
        try {
            objExtClass = cExtClass.newInstance();
            Class[] paramTypes = new Class[]{Marker[].class};
            Method method = cExtClass.getMethod(METHOD_NAME, paramTypes);
            Marker[] markerArray = new Marker[]{MarkerFactory.getDetachedMarker((String)SECURITY_SUCCESS_MARKER_NAME), MarkerFactory.getDetachedMarker((String)CONFIDENTIAL_MARKER_NAME)};
            markerSecurSuccConfid = (Marker)method.invoke(objExtClass, new Object[]{markerArray});
            markerArray[0] = MarkerFactory.getDetachedMarker((String)SECURITY_FAILURE_MARKER_NAME);
            markerSecurFailConfid = (Marker)method.invoke(objExtClass, new Object[]{markerArray});
            markerArray[0] = MarkerFactory.getDetachedMarker((String)SECURITY_AUDIT_MARKER_NAME);
            markerSecurAuditConfid = (Marker)method.invoke(objExtClass, new Object[]{markerArray});
            initialized = true;
        }
        catch (Exception e) {
            LOG.warn("Error getting Method '{}' of Class '{}'. Falling back to default.", (Object)METHOD_NAME, (Object)cExtClass.getName());
            LOG.warn("Exception occurred.", (Throwable)e);
            e.printStackTrace();
            SecureLogging.createDefaultMarkers();
        }
    }

    public static boolean hasExtClass() {
        Class<String> cExtClass = SecureLogging.findExtClass(EXT_CLASS);
        return !cExtClass.isAssignableFrom(String.class);
    }

    private static Class<?> findExtClass(String className) {
        try {
            Class<?> cExtClass = Class.forName(className);
            return cExtClass;
        }
        catch (Exception e) {
            LOG.debug("Class '{}' or one of its dependencies is not present.", (Object)className);
            Class<String> cExtClass = String.class;
            return cExtClass;
        }
    }
}

