/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.impl.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.web.filter.GenericFilterBean;

public class RetainAnchorFilter
extends GenericFilterBean {
    private String storeUrlPattern;
    private String restoreUrlPattern;
    private String cookieName;

    public void setStoreUrlPattern(String storeUrlPattern) {
        this.storeUrlPattern = storeUrlPattern;
    }

    public void setRestoreUrlPattern(String restoreUrlPattern) {
        this.restoreUrlPattern = restoreUrlPattern;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wrappedResponse = response;
        if (response instanceof HttpServletResponse) {
            wrappedResponse = new RedirectResponseWrapper((HttpServletResponse)response);
        }
        chain.doFilter(request, wrappedResponse);
    }

    private class RedirectResponseWrapper
    extends HttpServletResponseWrapper {
        public RedirectResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void sendRedirect(String location) throws IOException {
            HttpServletResponse response = (HttpServletResponse)this.getResponse();
            String redirectPageHtml = "";
            if (location.matches(RetainAnchorFilter.this.storeUrlPattern)) {
                redirectPageHtml = this.generateStoreAnchorRedirectPageHtml(location);
            } else if (location.matches(RetainAnchorFilter.this.restoreUrlPattern)) {
                redirectPageHtml = this.generateRestoreAnchorRedirectPageHtml(location);
            } else {
                super.sendRedirect(location);
                return;
            }
            response.setContentType("text/html;charset=UTF-8");
            response.setContentLength(redirectPageHtml.length());
            response.getWriter().write(redirectPageHtml);
        }

        private String generateStoreAnchorRedirectPageHtml(String location) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><head><title>Redirect Page</title>\n");
            sb.append("<script type=\"text/javascript\">\n");
            sb.append("document.cookie = '" + RetainAnchorFilter.this.cookieName + "=' + window.location.hash + '; path=/';\n");
            sb.append("window.location = '" + location + "' + window.location.hash;\n");
            sb.append("</script>\n</head>\n");
            sb.append("<body><h1>Redirect Page (Store Anchor)</h1>\n");
            sb.append("Should redirect to " + location + "\n");
            sb.append("</body></html>\n");
            return sb.toString();
        }

        private String generateRestoreAnchorRedirectPageHtml(String location) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html><head><title>Redirect Page</title>");
            sb.append("<script type='text/javascript'>");
            sb.append("var cookieParser = /" + RetainAnchorFilter.this.cookieName + "=([^;]*)(?:;|$)/;");
            sb.append("var getCookie = function() {");
            sb.append("  var m = cookieParser.exec(document.cookie);");
            sb.append("  if (m != null && m.length == 2) {");
            sb.append("    return unescape(m[1]);");
            sb.append("  } else {");
            sb.append("    return false;");
            sb.append("  }");
            sb.append("};");
            sb.append("var targetAnchor = getCookie();");
            sb.append("if (targetAnchor) {");
            sb.append("  window.location = '" + location + "' + targetAnchor;");
            sb.append("} else {");
            sb.append("  window.location = '" + location + "';");
            sb.append("}");
            sb.append("document.cookie = '" + RetainAnchorFilter.this.cookieName + "=; expires=Thu, 01-Jan-70 00:00:01 GMT; path=/';");
            sb.append("</script>");
            sb.append("</head>");
            sb.append("<body>");
            sb.append("<h1>Redirect Page (Restore Anchor)</h1>");
            sb.append("<p>Should redirect to " + location + "</p>");
            sb.append("</body>");
            sb.append("</html>");
            return sb.toString();
        }
    }
}

