/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.callbacks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * An extension of {@link ContextCallback} that allows many callbacks for each
 * call context.
 * <P>
 * This interface and its extensions are alternatives to the {@link Stream}
 * interface hierarchy that allow the application to associate an arbitrary
 * context object with each call. Any suitable application object can be
 * provided as the context. It will be passed on to the corresponding callback
 * methods, allowing requests and responses to be correlated. The context object
 * is optional (it may be {@code null}).
 * <P>
 * In all other respects {@link Stream} and {@link ContextStream} behave
 * identically.
 *
 * @author DiffusionData Limited
 * @since 5.1
 * @param <C> context object type
 *
 * @deprecated since 6.7
 *             <p>
 *             Methods that use contextual callbacks are deprecated and will be
 *             removed in a future release. Use CompletableFuture variant
 *             instead.
 */
@Deprecated
public interface ContextStream<C> extends ContextCallback<C> {

    /**
     * Notification that a call context was closed normally. No further calls
     * will be made to this callback.
     *
     * @param context the context object the application supplied when making
     *        the call; may be {@code null}
     */
    void onClose(C context);

    /**
     * Abstract default callback.
     * <P>
     * This simply logs an onClose call at 'debug' level. This method should be
     * overridden for more specific processing.
     *
     * @param <C> context object type
     */
    abstract class Default<C>
        extends ContextCallback.Default<C>
        implements ContextStream<C> {

        private static final Logger LOG =
            LoggerFactory.getLogger(ContextStream.Default.class);

        @Override
        public void onClose(C context) {
            LOG.debug("{} stream closed, context={}", this, context);
        }
    }
}
