/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A callback interface used to return results from a call to the server.
 * Extensions of this interface provide the callback method or methods.
 * <P>
 * Direct extensions of this interface support a single callback each time the
 * callback is used in a call (the <em>call context</em>). If the call fails to
 * return a result, for example if the session is closed or the operation times
 * out, {@link #onDiscard() onDiscard} will be called. Each call to the server
 * will result in invocation of either a single callback method or
 * {@code onDiscard}.
 * <P>
 * In most cases where a Callback can be used it is also possible to use a
 * {@link ContextCallback} which may be more useful if there is a need to
 * correlate the Callback invocation with the request that it matches. For
 * example, if the same Callback is used for severals requests, it might be
 * useful to be able to associate the reply (or discard) with the request that
 * was made using some context object.
 * <P>
 * If the server returns a response for an unknown call context (typically a
 * late response for a call context has timed out), an error will be reported to
 * the {@link com.pushtechnology.diffusion.client.session.Session.ErrorHandler
 * session error handler}.
 *
 * @author DiffusionData Limited
 * @since 5.0
 * @see ContextCallback
 *
 * @deprecated since 6.7
 *             <p>
 *             Methods that use callbacks are deprecated and will be removed in
 *             a future release. Use CompletableFuture variant instead.
 */
@Deprecated
public interface Callback {

    /**
     * This is called to notify that a call context was closed prematurely,
     * typically due to a timeout or the session being closed. No further calls
     * will be made for the context.
     */
    void onDiscard();

    /**
     * Abstract default callback.
     * <P>
     * This simply logs any onDiscard response at 'warn' level. The method
     * should be overridden if anything other than a logged warning would be
     * required in such an eventuality.
     */
    abstract class Default implements Callback {

        private static final Logger LOG =
            LoggerFactory.getLogger(Default.class);

        @Override
        public void onDiscard() {
            LOG.warn("{} - Callback discarded", this);
        }

    }
}
