/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.pushtechnology.diffusion.client.features;

import static com.pushtechnology.diffusion.client.callbacks.ErrorReason.CLUSTER_ROUTING;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * Indicates a cluster operation failed to be routed to a server within the
 * cluster due to a communication failure, or the server that owns a partition
 * is not currently known.
 * <p>
 * This is a transient error that occurs while the cluster is recovering from
 * failure. The operation can be retried.
 *
 * @author DiffusionData Limited
 * @since 6.5
 * @see ClusterRepartitionException
 */
public class ClusterRoutingException extends SessionException {

    private static final long serialVersionUID = -3365885433699836424L;

    /**
     * Constructor.
     */
    public ClusterRoutingException() {
        super(CLUSTER_ROUTING.getDescription());
    }

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public ClusterRoutingException(String message) {
        super(message);
    }

    /**
     * Constructor.
     *
     * @param message the exception message
     * @param cause the cause
     */
    public ClusterRoutingException(String message, Throwable cause) {
        super(message, cause);
    }
}
