/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A callback interface used to return results from a call to the server with
 * context supplied with the call. Extensions of this interface provide the
 * callback method or methods.
 * <P>
 * This interface and its extensions are alternatives to the {@link Callback}
 * interface hierarchy that allow the application to associate an arbitrary
 * context object with each call. Any suitable application object can be
 * provided as the context. It will be passed on to the corresponding callback
 * methods, allowing requests and responses to be correlated. The context object
 * is optional (it may be {@code null}).
 * <P>
 * In all other respects {@link Callback} and {@link ContextCallback} behave
 * identically.
 *
 * @author DiffusionData Limited
 * @since 5.0
 * @param <C> context object type
 * @see Callback
 *
 * @deprecated since 6.7
 *             <p>
 *             Methods that use contextual callbacks are deprecated and will be
 *             removed in a future release. Use CompletableFuture variant
 *             instead.
 */
@Deprecated
public interface ContextCallback<C> {

    /**
     * Notification that a call context was closed prematurely, typically due to
     * a timeout or the session being closed. No further calls will be made for
     * the context.
     *
     * @param context the context object supplied when making the call. May be
     *        {@code null}.
     */
    void onDiscard(C context);

    /**
     * Abstract default callback.
     * <P>
     * This simply logs any onDiscard response at 'warn' level. The method
     * should be overridden if anything other than a logged warning would be
     * required in such an eventuality.
     *
     * @param <C> context object type
     */
    abstract class Default<C> implements ContextCallback<C> {

        private static final Logger LOG =
            LoggerFactory.getLogger(Default.class);

        @Override
        public void onDiscard(C context) {
            LOG.warn("{} - Callback discarded, context={}", this, context);
        }
    }
}
