/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.pushtechnology.diffusion.client.session.Session;

/**
 * This is the base interface for all callback handlers registered via a client
 * {@link Session session} that establish a server side control presence for the
 * client.
 *
 * @author DiffusionData Limited
 * @since 5.0
 *
 * @deprecated since 6.7
 *             <p>
 *             This interface is only used by deprecated methods and will be
 *             removed in a future release.
 */
@Deprecated
public interface ServerHandler {

    /**
     * Called when the handler has been registered at the server and is now
     * active.
     * <P>
     * A session can register at most one a single handler of each type. If
     * there is already a handler registered the operation will fail,
     * {@code registeredHandler} will be closed, and the session error handler
     * will be notified. To change the handler, first
     * {@link RegisteredHandler#close close} the previous handler.
     *
     * @param registeredHandler a reference that allows the handler to be closed
     */
    void onActive(RegisteredHandler registeredHandler);

    /**
     * Called if the handler is closed. The handler will be closed if the
     * session is closed, or if the handler is unregistered using
     * {@link RegisteredHandler#close close}.
     */
    void onClose();

    /**
     * Abstract default server handler.
     * <P>
     * The methods on this handler simply log callbacks at debug level.
     */
    abstract class Default implements ServerHandler {

        private static final Logger LOG =
            LoggerFactory.getLogger(ServerHandler.Default.class);

        @Override
        public void onActive(RegisteredHandler registeredHandler) {
            LOG.debug("{} - Server handler active", this);
        }

        @Override
        public void onClose() {
            LOG.debug("{} - Server handler closed", this);
        }
    }
}
