/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.pushtechnology.diffusion.client.session.Session;

/**
 * Common base interface for callback handlers registered via the client
 * {@link Session session} that establish a server side control presence for a
 * branch of the topic tree.
 *
 * @author DiffusionData Limited
 * @since 5.0
 *
 * @deprecated since 6.7
 *             <p>
 *             This interface is only used by deprecated methods and will be
 *             removed in a future release.
 */
@Deprecated
public interface TopicTreeHandler {

    /**
     * Called when the handler has been registered at the server and is now
     * active.
     * <P>
     * A session can register a single handler of each type for a given branch
     * of the topic tree. If there is already a handler registered for the topic
     * path the operation will fail, {@code registeredHandler} will be closed,
     * and the session error handler will be notified. To change the handler,
     * first {@link RegisteredHandler#close close} the previous handler.
     *
     * @param topicPath the path that the handler is active for
     *
     * @param registeredHandler allows the handler to be closed
     */
    void onActive(String topicPath, RegisteredHandler registeredHandler);

    /**
     * Called if the handler is closed. The handler will be closed if the
     * session is closed, or if the handler is unregistered using
     * {@link RegisteredHandler#close close}.
     *
     * @param topicPath the branch of the topic tree for which the handler was
     *        registered
     */
    void onClose(String topicPath);

    /**
     * Abstract Default Topic Tree Handler.
     * <P>
     * This simply logs active and closed notifications at debug level.
     */
    abstract class Default implements TopicTreeHandler {

        private static final Logger LOG =
            LoggerFactory.getLogger(TopicTreeHandler.Default.class);

        @Override
        public void onActive(
            String topicPath, RegisteredHandler registeredHandler) {
            LOG.debug(
                "{} - Topic tree handler active for path {}",
                this,
                topicPath);
        }

        @Override
        public void onClose(String topicPath) {
            LOG.debug(
                "{} - Topic tree handler closed for path {}",
                this,
                topicPath);
        }
    }
}
