/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * Exception used to report a message was not delivered to an application
 * handler.
 *
 * <p>
 * For messages addressed to a session or sessions using the {@link Messaging}
 * feature, this exception indicates a message was delivered to a session, but
 * the session has no local handler for the message path.
 *
 * <p>
 * For messages addressed to the server using the {@link Messaging} feature,
 * this exception indicates the server has no handler registered for the
 * message path.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public final class UnhandledMessageException extends SessionException {

    private static final long serialVersionUID = 6927538865203744623L;

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public UnhandledMessageException(String message) {
        super(message);
    }
}