/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/

package com.pushtechnology.diffusion.client.features;

import com.pushtechnology.diffusion.client.session.SessionException;

/**
 * Exception used to report that a constraint was not satisfied.
 *
 * @author DiffusionData Limited
 * @since 6.2
 */
public final class UnsatisfiedConstraintException extends SessionException {
    private static final long serialVersionUID = 2760736810760872272L;

    /**
     * Constructor.
     *
     * @param message the exception message
     */
    public UnsatisfiedConstraintException(String message) {
        super(message);
    }
}
