/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
/**
 * <b>Client API : Control Features</b>.
 * <P>
 * This package provides the control features that allow a client
 * {@link com.pushtechnology.diffusion.client.session.Session Session} to
 * perform control functions.
 * <P>
 * A control {@link com.pushtechnology.diffusion.client.session.Feature feature}
 * represents a unit of functionality that is available to use within a
 * client
 * {@link com.pushtechnology.diffusion.client.session.Session session}. A
 * feature may be obtained from a session using the
 * {@link com.pushtechnology.diffusion.client.session.Session#feature(Class) feature}
 * method specifying the feature class. For example:
 * <pre><code>
 * TopicControl topicControl = session.feature(TopicControl.class);
 * </code></pre>
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
package com.pushtechnology.diffusion.client.features.control;