/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
/**
 * <b>Client API</b>.
 * <p>
 * The key component is the
 * {@link com.pushtechnology.diffusion.client.session.Session Session} which
 * enables a connection to be made to a server. The
 * {@link com.pushtechnology.diffusion.client.Diffusion Diffusion} singleton
 * provides access to various factories for common objects. To open a new
 * connection to a server the
 * {@link com.pushtechnology.diffusion.client.Diffusion#sessions() session
 * factory} is used.
 * <P>
 * Once a session has been established the functionality is enabled by various
 * {@link com.pushtechnology.diffusion.client.session.Feature features}. The
 * required feature(s) may be obtained using a method on the {@code Session}.
 * Standard client features may be found in the
 * {@code com.pushtechnology.diffusion.client.features} package and those that
 * provide control capabilities (including data feed) may be found in the
 * {@code com.pushtechnology.diffusion.client.features.control} package. Other
 * packages provide interfaces which are common across features.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
package com.pushtechnology.diffusion.client;

