/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * The session operation failed due to an authentication failure. Repeating
 * the operation with the same authentication credentials is likely to fail.
 *
 * @author DiffusionData Limited
 * @since 6.8
 */
public class AuthenticationException extends SessionSecurityException {

    private static final long serialVersionUID = -8470523360759944449L;

    /**
     * Constructor.
     */
    public AuthenticationException() {
        this(
            "The session operation failed due to a violated authentication constraint");
    }

    /**
     * @see SessionSecurityException#SessionSecurityException(String)
     *
     * @param description the exception message
     */
    public AuthenticationException(String description) {
        super(description);
    }

    /**
     * @see SessionSecurityException#SessionSecurityException(String, Throwable)
     *
     * @param description the exception message
     * @param cause of the exception
     */
    public AuthenticationException(String description, Throwable cause) {
        super(description, cause);
    }
}
