/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * The session is closed. No further operations are possible.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public class SessionClosedException extends SessionException {

    private static final long serialVersionUID = -2658690087333766540L;

    /**
     * Constructor.
     */
    public SessionClosedException() {
        this("The session is closed. No further operations are possible");
    }

    /**
     * Constructor.
     */
    public SessionClosedException(String message) {
        super(message);
    }

    /**
     * @see SessionException#SessionException(Throwable)
     *
     * @param cause of the session closure, if any, may be null
     */
    public SessionClosedException(Throwable cause) {
        this("The session is closed. No further operations are possible",
            cause);
    }
    /**
     * @see SessionException#SessionException(String, Throwable)
     *
     * @param description of the exception
     *
     * @param cause of the session closure, if any, may be null
     */
    protected SessionClosedException(String description, Throwable cause) {
        super(description, cause);
    }
}
