/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * There was a problem when establishing a Session.
 *
 * @author DiffusionData Limited
 * @since 5.1
 */
public class SessionEstablishmentException extends SessionClosedException {

    private static final long serialVersionUID = -1305460330313652757L;

    /**
     * Constructor.
     */
    public SessionEstablishmentException(String message) {
        super(message);
    }

    /**
     * @see SessionClosedException#SessionClosedException(Throwable)
     *
     * @param cause of the failure, if any, may be null
     */
    public SessionEstablishmentException(Throwable cause) {
        this("The session failed to be established. No further operations are possible",
            cause);
    }

    /**
     * @see SessionClosedException#SessionClosedException(String, Throwable)
     *
     * @param description of the exception
     *
     * @param cause of the failure, if any, may be null
     */
    public SessionEstablishmentException(String description, Throwable cause) {
        super(description, cause);
    }
}
