/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * Represents a transient problem when establishing a session.
 * <p>
 * On receiving such an exception it is reasonable for the caller to try opening
 * a session again.
 *
 * @author DiffusionData Limited
 * @since 6.6
 */
public class SessionEstablishmentTransientException
    extends SessionEstablishmentException {

    private static final long serialVersionUID = 3316376354885332828L;

    /**
     * Constructor.
     */
    public SessionEstablishmentTransientException(String message) {
        super(message);
    }

    /**
     * Constructor.
     */
    public SessionEstablishmentTransientException(Throwable cause) {
        super(cause);
    }
}
