/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

/**
 * General class of exceptions indicating a {@link Session} specific
 * failure.
 * <P>
 * A {@code SessionException} may result from any of the API methods that
 * interact with the server.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public class SessionException extends RuntimeException {

    private static final long serialVersionUID = 4656998400937006125L;

    /**
     * @see RuntimeException#RuntimeException()
     */
    public SessionException() {
    }

    /**
     * @see RuntimeException#RuntimeException(String)
     *
     * @param description the exception message
     */
    public SessionException(String description) {
        super(description);
    }

    /**
     * @see RuntimeException#RuntimeException(Throwable)
     *
     * @param cause the exception cause
     */
    public SessionException(Throwable cause) {
        super(cause);
    }

    /**
     * @see RuntimeException#RuntimeException(String, Throwable)
     *
     * @param description of the exception
     *
     * @param cause of the exception
     */
    public SessionException(String description, Throwable cause) {
        super(description, cause);
    }
}
