/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.session;

import com.pushtechnology.diffusion.client.Diffusion;

/**
 * A unique {@link Session} identifier, allocated by the server.
 *
 * @author DiffusionData Limited
 * @since 5.0
 */
public interface SessionId {

    /**
     * Returns hash code of session identifier.
     *
     * @return hash code
     *
     * @see Object#hashCode()
     */
    @Override
    int hashCode();

    /**
     * Checks identifier against another object for equality.
     *
     * @param obj the object to check
     *
     * @return true if {@code obj} is of the same type and identifies the same
     *         session
     *
     * @see Object#equals(Object)
     */
    @Override
    boolean equals(Object obj);

    /**
     * Returns a string representation of the session identifier.
     *
     * <p>
     * This string is useful where the session identity needs to be logged,
     * stored in a database, or passed indirectly in an application message.
     * Using
     * {@link Diffusion#sessionIdFromString}, the string can later be
     * converted back to a {@code SessionId} that can be used to interact with
     * the server hosting the session.
     *
     * <p>
     * The format of the string is subject to change between product releases.
     * The current format is a 33-character string consisting of a pair of
     * 16-digit, lower case hexadecimal numbers, separated by a '-'. For
     * example:
     *
     * <pre>
     * 2d5f8e2fab472dce-0000000100000007
     * </pre>
     *
     * @return string representation of session identifier
     *
     * @see Object#toString()
     */
    @Override
    String toString();
}
