/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.types;

/**
 * Permissions that protect globally scoped, access-controlled operations. There
 * is no related object, permission is granted globally.
 *
 * @author DiffusionData Limited
 * @since 5.2
 * @see PathPermission
 */
public enum GlobalPermission implements Permission {

    /**
     * Add an authentication handler.
     */
    AUTHENTICATE,

    /**
     * List or listen to client sessions.
     */
    VIEW_SESSION,

    /**
     * Alter a client session. This covers a range of actions including:
     *
     * <ul>
     * <li>subscribe session to topic
     * <li>enable conflation for session
     * <li>close session
     * </ul>
     */
    MODIFY_SESSION,

    /**
     * Required to register any server-side handler.
     *
     * <p>
     * This restricts clients from consuming resources by registering long lived
     * handlers (or example, addMessageHandler). Typically these would never be
     * called due to lack of other permissions.
     */
    REGISTER_HANDLER,

    /**
     * View the server's runtime state - for example, read metrics.
     */
    VIEW_SERVER,

    /**
     * Change the server's runtime state - for example, shut it down.
     */
    CONTROL_SERVER,

    /**
     * Read the security configuration.
     */
    VIEW_SECURITY,

    /**
     * Change the security configuration.
     */
    MODIFY_SECURITY,

    /**
     * A permission that is unsupported by the session.
     *
     * @since 6.1
     */
    UNKNOWN_GLOBAL_PERMISSION,

    /**
     * Read topic views.
     *
     * @since 6.3
     */
    READ_TOPIC_VIEWS,

    /**
     * Modify topic views.
     *
     * @since 6.3
     */
    MODIFY_TOPIC_VIEWS,
}
