/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.client.types;

import com.pushtechnology.diffusion.client.features.TimeSeries;
import com.pushtechnology.diffusion.client.features.TimeSeries.Query;
import com.pushtechnology.diffusion.client.session.Session;

/**
 * Permissions protecting access-controlled operations that are evaluated for a
 * specific path.
 *
 * @author DiffusionData Limited
 * @since 5.2
 * @see GlobalPermission
 * @deprecated since 6.5. Replaced by the equivalent {@link PathPermission}. In
 *             previous releases, the path-scoped permissions were called "topic
 *             permissions". This was a source of confusion since some of the
 *             permissions apply to message paths or to session lock names, both
 *             of which are hierarchical but have nothing to do with topics in
 *             the topic tree. The term "topic permission" has been renamed
 *             "path permission" throughout the API. Additional methods have
 *             been added to reflect this renaming. The old methods are
 *             deprecated and will be removed in a future release.
 */
@Deprecated
public enum TopicPermission implements Permission {

    /**
     * Use a topic selector that selects the topic path.
     *
     * <p>
     * A session must have this permission for the
     * {@link com.pushtechnology.diffusion.client.topics.TopicSelector#getPathPrefix()
     * path prefix} of any topic selector used to subscribe or fetch.
     *
     * <p>
     * When the subscription or fetch request completes, the resulting topics
     * are further filtered based on the {@link #READ_TOPIC} permission.
     *
     * <p>
     * A session that has {@code READ_TOPIC} but not {@code SELECT_TOPIC} for a
     * particular topic path cannot subscribe directly to topics belonging to
     * the path. However, the session can be independently subscribed by a
     * control session that has {@link GlobalPermission#MODIFY_SESSION}
     * permission in addition to the appropriate {@code SELECT_TOPIC}
     * permission.
     *
     * @since 5.7
     */
    SELECT_TOPIC,

    /**
     * Required to receive information from a topic.
     *
     * <p>
     * If a session does not have read_topic permission for a topic, the topic
     * will be excluded from the results of subscription or fetch operations for
     * the session, and the topic's details cannot be retrieved by the session.
     *
     * @see #SELECT_TOPIC
     */
    READ_TOPIC,

    /**
     * Update a topic.
     */
    UPDATE_TOPIC,

    /**
     * Add a topic or remove a topic.
     */
    MODIFY_TOPIC,

    /**
     * Send a message to a handler registered with the server.
     */
    SEND_TO_MESSAGE_HANDLER,

    /**
     * Send a message to a client session.
     */
    SEND_TO_SESSION,

    /**
     * Evaluate queries that return a non-current view of a time series topic.
     *
     * <p>
     * The {@link #READ_TOPIC} permission is required to evaluate any type of
     * {@link Query} for a time series topic. This permission is additionally
     * required for queries that potentially return a non-current view of all or
     * part of a time series. Such queries include value range queries that
     * specify an edit range, and all types of edit range query.
     *
     * @since 6.0
     * @see TimeSeries
     */
    QUERY_OBSOLETE_TIME_SERIES_EVENTS,

    /**
     * Submit edits to time series topic events.
     *
     * <p>
     * The {@link #UPDATE_TOPIC} permission is required to update a time series
     * topic. This permission is additionally required to submit
     * {@link TimeSeries#edit edits} to a time series topic.
     *
     * @since 6.0
     * @see TimeSeries
     * @see #EDIT_OWN_TIME_SERIES_EVENTS
     */
    EDIT_TIME_SERIES_EVENTS,

    /**
     * Submit edits to time series topic events which have an author which is
     * the same as the principal of the calling session.
     *
     * <p>This permission is a more restrictive alternative to
     * {@link #EDIT_TIME_SERIES_EVENTS}.
     *
     * <p>
     * The {@link #UPDATE_TOPIC} permission is required to update a time series
     * topic. This permission is additionally required to submit
     * {@link TimeSeries#edit edits} to a time series topic where the event
     * author is the same as the principal of the calling session.
     *
     * @since 6.0
     * @see TimeSeries
     * @see #EDIT_TIME_SERIES_EVENTS
     */
    EDIT_OWN_TIME_SERIES_EVENTS,

    /**
     * Acquire a session lock.
     *
     * @since 6.1
     * @see Session#lock
     */
    ACQUIRE_LOCK,

    /**
     * A permission that is unsupported by the session.
     *
     * @since 6.1
     */
    UNKNOWN_TOPIC_PERMISSION,
}
