/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.datatype.recordv2;

import java.util.Collection;

import com.pushtechnology.diffusion.datatype.recordv2.schema.Schema;

/**
 * Builds free format {@link RecordV2 RecordV2 value}.
 * <P>
 * This type of builder may be used to generate free format
 * {@link RecordV2} format data which is not constrained by a
 * {@link Schema}.
 * <P>
 * Such a builder can be created using {@link RecordV2DataType#valueBuilder()}.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public interface RecordV2Builder {

    /**
     * Adds one or more field values.
     * <P>
     * If there is a current record, this adds the fields to the end of the
     * current record.
     *
     * @param values field values
     *
     * @return this builder
     */
    RecordV2Builder addFields(Collection<String> values);

    /**
     * Adds one or more field values.
     * <P>
     * If there is a current record, this adds the fields to the end of the
     * current record.
     *
     * @param values field values
     *
     * @return this builder
     */
    RecordV2Builder addFields(String... values);

    /**
     * Adds a new record comprising the specified field values.
     *
     * @param fields the fields within the new record. If no fields are
     *        supplied, an empty record will be added.
     *
     * @return this builder
     */
    RecordV2Builder addRecord(Collection<String> fields);

    /**
     * Adds a new record comprising the specified field values.
     *
     * @param fields the fields within the new record. If no fields are
     *        supplied, an empty record will be added.
     *
     * @return this builder
     */
    RecordV2Builder addRecord(String... fields);

    /**
     * Clears all current values from the builder allowing it to be reused to
     * generate new data.
     *
     * @return this builder
     */
    RecordV2Builder clear();

    /**
     * Builds a {@link RecordV2} object from the current builder state.
     *
     * @return a new {@link RecordV2} object.
     */
    RecordV2 build();

}
