/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
/**
 * <b>RecordV2 Data Type : Data Model</b>.
 * <P>
 * This package contains additional interfaces relating to data modeling within
 * the
 * {@link com.pushtechnology.diffusion.datatype.recordv2.RecordV2DataType
 * record based data type}.
 * <P>
 * A model is a representation of
 * {@link com.pushtechnology.diffusion.datatype.recordv2.RecordV2DataType
 * record based data} based upon a
 * {@link com.pushtechnology.diffusion.datatype.recordv2.schema.Schema
 * schema} that allows direct access to records and fields within the data. A
 * read-only model can be created from a
 * {@link com.pushtechnology.diffusion.datatype.recordv2.RecordV2
 * value} object. Alternatively, a mutable model can be created from a schema
 * which allows updates to be performed to the data (constrained by the schema)
 * and
 * {@link com.pushtechnology.diffusion.datatype.recordv2.RecordV2
 * records} objects to be generated from the mutated data.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
package com.pushtechnology.diffusion.datatype.recordv2.model;
