/*******************************************************************************
 * Copyright (c) 2023 DiffusionData Ltd., All Rights Reserved.
 *
 * Use is subject to license terms.
 *
 * NOTICE: All information contained herein is, and remains the
 * property of Push Technology. The intellectual and technical
 * concepts contained herein are proprietary to Push Technology and
 * may be covered by U.S. and Foreign Patents, patents in process, and
 * are protected by trade secret or copyright law.
 *******************************************************************************/
package com.pushtechnology.diffusion.datatype.recordv2.schema;

/**
 * Indicates a problem that has occurred when building a {@link Schema}.
 *
 * @author DiffusionData Limited
 * @since 6.0
 */
public final class SchemaViolationException extends RuntimeException {

    private static final long serialVersionUID = 8970456537582784776L;

    /**
     * Constructor.
     *
     * @param message the error message
     * @param cause the cause of the exception
     */
    public SchemaViolationException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor.
     *
     * @param message the error message
     */
    public SchemaViolationException(String message) {
        super(message);
    }

}
