/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.patterns;

import com.dslplatform.client.StandardProxy;
import com.dslplatform.patterns.Identifiable;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.patterns.Specification;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class CubeBuilder<T extends Identifiable> {
    private final ServiceLocator locator;
    private final String cubeName;
    private Specification<T> specification;
    private final List<String> dimensions;
    private final List<String> facts;
    private final List<Map.Entry<String, Boolean>> order;

    public CubeBuilder(String string, ServiceLocator serviceLocator) {
        this.cubeName = string;
        this.locator = serviceLocator;
        this.dimensions = new LinkedList<String>();
        this.facts = new LinkedList<String>();
        this.order = new ArrayList<Map.Entry<String, Boolean>>();
    }

    public CubeBuilder<T> with(Specification<T> specification) {
        this.specification = specification;
        return this;
    }

    public CubeBuilder<T> addDimension(String string) {
        this.dimensions.add(string);
        return this;
    }

    public CubeBuilder<T> addDimensions(Collection<String> collection) {
        collection.addAll(collection);
        return this;
    }

    public CubeBuilder<T> addFact(String string) {
        this.facts.add(string);
        return this;
    }

    public CubeBuilder<T> addFacts(Collection<String> collection) {
        collection.addAll(collection);
        return this;
    }

    private CubeBuilder<T> orderBy(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("property can't be empty");
        }
        this.order.add(new AbstractMap.SimpleEntry<String, Boolean>(string, bl));
        return this;
    }

    public CubeBuilder<T> ascending(String string) {
        return this.orderBy(string, true);
    }

    public CubeBuilder<T> descending(String string) {
        return this.orderBy(string, false);
    }

    public <TResult> List<TResult> analyze(Class<TResult> clazz) throws IOException {
        StandardProxy standardProxy = this.locator.resolve(StandardProxy.class);
        try {
            return this.specification == null ? standardProxy.olapCube(clazz, this.cubeName, this.dimensions, this.facts, this.order).get() : standardProxy.olapCube(clazz, this.cubeName, this.specification, this.dimensions, this.facts, this.order).get();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
    }
}

