/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.patterns;

import com.dslplatform.patterns.Searchable;
import com.dslplatform.patterns.SearchableRepository;
import com.dslplatform.patterns.Specification;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class SearchBuilder<T extends Searchable> {
    private final SearchableRepository<T> repository;
    private Specification<T> specification;
    private Integer limit;
    private Integer offset;
    private final List<Map.Entry<String, Boolean>> order;

    public SearchBuilder(SearchableRepository<T> searchableRepository) {
        this.repository = searchableRepository;
        this.order = new ArrayList<Map.Entry<String, Boolean>>();
    }

    public SearchBuilder<T> with(Specification<T> specification) {
        this.specification = specification;
        return this;
    }

    public SearchBuilder<T> filter(Specification<T> specification) {
        this.specification = specification;
        return this;
    }

    public SearchBuilder<T> limit(int n) {
        return this.take(n);
    }

    public SearchBuilder<T> take(int n) {
        this.limit = n;
        return this;
    }

    public SearchBuilder<T> offset(int n) {
        return this.skip(n);
    }

    public SearchBuilder<T> skip(int n) {
        this.offset = n;
        return this;
    }

    private SearchBuilder<T> orderBy(String string, boolean bl) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("property can't be empty");
        }
        this.order.add(new AbstractMap.SimpleEntry<String, Boolean>(string, bl));
        return this;
    }

    public SearchBuilder<T> ascending(String string) {
        return this.orderBy(string, true);
    }

    public SearchBuilder<T> descending(String string) {
        return this.orderBy(string, false);
    }

    public Future<List<T>> search() {
        return this.specification == null ? this.repository.findAll(this.limit, this.offset, this.order) : this.repository.search(this.specification, this.limit, this.offset, this.order);
    }
}

