/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.DomainProxy;
import com.dslplatform.client.HttpClient;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.patterns.AggregateDomainEvent;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.DomainEvent;
import com.dslplatform.patterns.Identifiable;
import com.dslplatform.patterns.Searchable;
import com.dslplatform.patterns.Specification;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

class HttpDomainProxy
implements DomainProxy {
    private static final String DOMAIN_URI = "Domain.svc/";
    private static final String APPLICATION_URI = "RestApplication.svc/";
    private final HttpClient client;

    public HttpDomainProxy(HttpClient httpClient) {
        this.client = httpClient;
    }

    @Override
    public <T extends Identifiable> Future<List<T>> find(Class<T> clazz, String[] stringArray) {
        return this.find(clazz, Arrays.asList(stringArray));
    }

    @Override
    public <T extends Identifiable> Future<List<T>> find(Class<T> clazz, Iterable<String> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("uris can't be null.");
        }
        String string = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildCollectionType(ArrayList.class, clazz), "RestApplication.svc/GetDomainObject", "POST", new GetArgument(string, iterable), new int[]{200});
    }

    @Override
    public <T extends Searchable> Future<List<T>> search(Specification<T> specification, Integer n, Integer n2, Iterable<Map.Entry<String, Boolean>> iterable) {
        if (specification == null) {
            throw new IllegalArgumentException("Specification can't be null");
        }
        Class<?> clazz = specification.getClass();
        Class<?> clazz2 = clazz.getDeclaringClass();
        String string = this.client.getDslName(clazz2);
        String string2 = Utils.appendLimitOffsetOrder(string + "?specification=" + clazz.getSimpleName(), n, n2, iterable, false);
        return this.client.sendRequest(JsonSerialization.buildCollectionType(ArrayList.class, clazz2), "Domain.svc/search/" + string2, "PUT", specification, new int[]{200});
    }

    @Override
    public <T extends Searchable> Future<List<T>> search(Specification<T> specification, Integer n, Integer n2) {
        return this.search(specification, n, n2, null);
    }

    @Override
    public <T extends Searchable> Future<List<T>> search(Specification<T> specification) {
        return this.search(specification, null, null, null);
    }

    @Override
    public <T extends Searchable> Future<List<T>> findAll(Class<T> clazz, Integer n, Integer n2, Iterable<Map.Entry<String, Boolean>> iterable) {
        String string = this.client.getDslName(clazz);
        String string2 = Utils.appendLimitOffsetOrder(string, n, n2, iterable, true);
        return this.client.sendRequest(JsonSerialization.buildCollectionType(ArrayList.class, clazz), "Domain.svc/search/" + string2, "GET", null, new int[]{200});
    }

    @Override
    public <T extends Searchable> Future<List<T>> findAll(Class<T> clazz, Integer n, Integer n2) {
        return this.findAll(clazz, n, n2, null);
    }

    @Override
    public <T extends Searchable> Future<List<T>> findAll(Class<T> clazz) {
        return this.findAll(clazz, null, null, null);
    }

    @Override
    public <T extends Searchable> Future<Long> count(Class<T> clazz) {
        String string = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildType(Long.class), "Domain.svc/count/" + string, "GET", null, new int[]{200});
    }

    @Override
    public <T extends Searchable> Future<Long> count(Specification<T> specification) {
        Class<?> clazz = specification.getClass();
        String string = this.client.getDslName(clazz.getDeclaringClass());
        return this.client.sendRequest(JsonSerialization.buildType(Long.class), "Domain.svc/count/" + string + "?specification=" + clazz.getSimpleName(), "PUT", specification, new int[]{200});
    }

    @Override
    public <TEvent extends DomainEvent> Future<String> submit(TEvent TEvent) {
        String string = this.client.getDslName(TEvent.getClass());
        return this.client.sendRequest(JsonSerialization.buildType(String.class), "Domain.svc/submit/" + string, "POST", TEvent, new int[]{201});
    }

    @Override
    public <TAggregate extends AggregateRoot, TEvent extends AggregateDomainEvent<TAggregate>> Future<TAggregate> submit(TEvent TEvent, String string) {
        if (string == null) {
            throw new IllegalArgumentException("uri can't be null.");
        }
        Class<?> clazz = TEvent.getClass();
        Class<?> clazz2 = clazz.getEnclosingClass();
        String string2 = this.client.getDslName(clazz2);
        return this.client.sendRequest(JsonSerialization.buildType(clazz2), "Domain.svc/submit/" + string2 + "/" + clazz.getSimpleName() + "?uri=" + HttpClient.encode(string), "POST", TEvent, new int[]{201});
    }

    private static class GetArgument {
        public final String Name;
        public final ArrayList<String> Uri;

        private GetArgument() {
            this.Name = null;
            this.Uri = null;
        }

        public GetArgument(String string, Iterable<String> iterable) {
            this.Name = string;
            this.Uri = Utils.toArrayList(iterable);
        }
    }
}

