/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.HttpClient;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.patterns.Searchable;
import com.dslplatform.patterns.ServiceLocator;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class GenericSearchBuilder<T extends Searchable> {
    private final Class<T> manifest;
    private final String domainName;
    private final HttpClient httpClient;
    private final Map<String, List<FilterPair>> filters;
    private Integer limit;
    private Integer offset;
    private final ArrayList<Map.Entry<String, Boolean>> order = new ArrayList(0);

    public GenericSearchBuilder(Class<T> clazz, ServiceLocator serviceLocator) {
        this.manifest = clazz;
        this.httpClient = serviceLocator.resolve(HttpClient.class);
        this.domainName = this.httpClient.getDslName(clazz);
        this.filters = new HashMap<String, List<FilterPair>>();
    }

    public GenericSearchBuilder<T> take(int n) {
        this.limit = n;
        return this;
    }

    public GenericSearchBuilder<T> limit(int n) {
        return this.take(n);
    }

    public GenericSearchBuilder<T> skip(int n) {
        this.offset = n;
        return this;
    }

    public GenericSearchBuilder<T> offset(int n) {
        return this.skip(n);
    }

    public Future<List<T>> search() {
        String string = Utils.appendLimitOffsetOrder(this.domainName, this.limit, this.offset, this.order, false);
        return this.httpClient.sendRequest(JsonSerialization.buildCollectionType(ArrayList.class, this.manifest), "Domain.svc/search-generic/" + string, "PUT", this.filters, new int[]{200});
    }

    private GenericSearchBuilder<T> orderBy(String string, Boolean bl) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("property can't be null");
        }
        this.order.add(new AbstractMap.SimpleEntry<String, Boolean>(string, bl));
        return this;
    }

    public GenericSearchBuilder<T> ascending(String string) {
        return this.orderBy(string, true);
    }

    public GenericSearchBuilder<T> descending(String string) {
        return this.orderBy(string, false);
    }

    private GenericSearchBuilder<T> filter(String string, int n, Object object) throws IOException {
        List<Object> list;
        String string2;
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("property can't be null");
        }
        String string3 = string2 = object != null ? JsonSerialization.serialize(object) : null;
        if (!this.filters.containsKey(string)) {
            list = new ArrayList();
            this.filters.put(string, list);
        } else {
            list = this.filters.get(string);
        }
        list.add(new FilterPair(n, string2));
        return this;
    }

    public GenericSearchBuilder<T> equal(String string, Object object) throws IOException {
        return this.filter(string, 0, object);
    }

    public GenericSearchBuilder<T> nonEqual(String string, Object object) throws IOException {
        return this.filter(string, 1, object);
    }

    public GenericSearchBuilder<T> lessThen(String string, Object object) throws IOException {
        return this.filter(string, 2, object);
    }

    public GenericSearchBuilder<T> lessThenOrEqual(String string, Object object) throws IOException {
        return this.filter(string, 3, object);
    }

    public GenericSearchBuilder<T> greaterThen(String string, Object object) throws IOException {
        return this.filter(string, 4, object);
    }

    public GenericSearchBuilder<T> greaterThenOrEqual(String string, Object object) throws IOException {
        return this.filter(string, 5, object);
    }

    public GenericSearchBuilder<T> in(String string, Object object) throws IOException {
        return this.filter(string, 6, object);
    }

    public GenericSearchBuilder<T> notIn(String string, Object object) throws IOException {
        return this.filter(string, 7, object);
    }

    public GenericSearchBuilder<T> inValue(String string, Object object) throws IOException {
        return this.filter(string, 8, object);
    }

    public GenericSearchBuilder<T> notInValue(String string, Object object) throws IOException {
        return this.filter(string, 9, object);
    }

    public GenericSearchBuilder<T> startsWith(String string, String string2) throws IOException {
        return this.filter(string, 10, string2);
    }

    public GenericSearchBuilder<T> startsWith(String string, String string2, boolean bl) throws IOException {
        return bl ? this.filter(string, 11, string2) : this.filter(string, 10, string2);
    }

    public GenericSearchBuilder<T> doesntStartsWith(String string, String string2) throws IOException {
        return this.filter(string, 12, string2);
    }

    public GenericSearchBuilder<T> doesntStartsWith(String string, String string2, boolean bl) throws IOException {
        return bl ? this.filter(string, 13, string2) : this.filter(string, 12, string2);
    }

    public GenericSearchBuilder<T> valueStartsWith(String string, String string2) throws IOException {
        return this.filter(string, 14, string2);
    }

    public GenericSearchBuilder<T> valueStartsWith(String string, String string2, boolean bl) throws IOException {
        return bl ? this.filter(string, 15, string2) : this.filter(string, 14, string2);
    }

    public GenericSearchBuilder<T> valueDoesntStartsWith(String string, String string2) throws IOException {
        return this.filter(string, 16, string2);
    }

    public GenericSearchBuilder<T> valueDoesntStartsWith(String string, String string2, boolean bl) throws IOException {
        return bl ? this.filter(string, 17, string2) : this.filter(string, 16, string2);
    }

    static class GenericSearchFilter {
        public static final int EQUALS = 0;
        public static final int NOT_EQUALS = 1;
        public static final int LESS_THEN = 2;
        public static final int LESS_THEN_OR_EQUAL = 3;
        public static final int GREATER_THEN = 4;
        public static final int GREATER_THEN_OR_EQUAL = 5;
        public static final int VALUE_IN = 6;
        public static final int NOT_VALUE_IN = 7;
        public static final int IN_VALUE = 8;
        public static final int NOT_IN_VALUE = 9;
        public static final int STARTS_WITH_VALUE = 10;
        public static final int STARTS_WITH_CASE_INSENSITIVE_VALUE = 11;
        public static final int NOT_STARTS_WITH_VALUE = 12;
        public static final int NOT_STARTS_WITH_CASE_INSENSITIVE_VALUE = 13;
        public static final int VALUE_STARTS_WITH = 14;
        public static final int VALUE_STARTS_WITH_CASE_INSENSITIVE = 15;
        public static final int NOT_VALUE_STARTS_WITH = 16;
        public static final int NOT_VALUE_STARTS_WITH_CASE_INSENSITIVE = 17;

        GenericSearchFilter() {
        }
    }

    static class FilterPair {
        public final Integer Key;
        public final String Value;

        public FilterPair(int n, String string) {
            this.Key = n;
            this.Value = string;
        }

        private FilterPair() {
            this.Key = null;
            this.Value = null;
        }
    }
}

