/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.patterns;

public class Either<T> {
    private final T value;
    private final Throwable error;

    private Either(T t, Throwable throwable) {
        this.value = t;
        this.error = throwable;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    public T get() {
        return this.value;
    }

    public Throwable whyNot() {
        return this.error;
    }

    public String explainError() {
        return this.error.getMessage();
    }

    public static <T> Either<T> success(T t) {
        return new Either<T>(t, null);
    }

    public static <T> Either<T> fail(Throwable throwable) {
        return new Either<Object>(null, throwable != null ? throwable : new Throwable());
    }

    public static <T> Either<T> fail(String string) {
        return new Either<Object>(null, new Throwable(string != null ? string : ""));
    }
}

