/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.CrudProxy;
import com.dslplatform.client.HttpClient;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.Identifiable;
import java.util.concurrent.Future;

class HttpCrudProxy
implements CrudProxy {
    private static final String CRUD_URI = "Crud.svc/";
    private final HttpClient client;

    public HttpCrudProxy(HttpClient httpClient) {
        this.client = httpClient;
    }

    @Override
    public <T extends Identifiable> Future<T> read(Class<T> clazz, String string) {
        if (string == null) {
            throw new IllegalArgumentException("uri can't be null.");
        }
        String string2 = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildType(clazz), CRUD_URI + string2 + "?uri=" + HttpClient.encode(string), "GET", null, new int[]{200});
    }

    @Override
    public <TAggregate extends AggregateRoot> Future<TAggregate> create(TAggregate TAggregate) {
        Class<?> clazz = TAggregate.getClass();
        String string = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildType(clazz), CRUD_URI + string, "POST", TAggregate, new int[]{201});
    }

    @Override
    public <TAggregate extends AggregateRoot> Future<TAggregate> update(TAggregate TAggregate) {
        String string = TAggregate.getURI();
        if (string == null) {
            throw new IllegalArgumentException("uri can't be null.");
        }
        Class<?> clazz = TAggregate.getClass();
        String string2 = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildType(clazz), CRUD_URI + string2 + "?uri=" + HttpClient.encode(string), "PUT", TAggregate, new int[]{200});
    }

    @Override
    public <TAggregate extends AggregateRoot> Future<TAggregate> delete(Class<TAggregate> clazz, String string) {
        if (string == null) {
            throw new IllegalArgumentException("uri can't be null.");
        }
        String string2 = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildType(clazz), CRUD_URI + string2 + "?uri=" + HttpClient.encode(string), "DELETE", null, new int[]{200});
    }
}

