/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.HttpClient;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.ReportingProxy;
import com.dslplatform.client.Utils;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.History;
import com.dslplatform.patterns.Identifiable;
import com.dslplatform.patterns.Report;
import com.dslplatform.patterns.Searchable;
import com.dslplatform.patterns.Specification;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

class HttpReportingProxy
implements ReportingProxy {
    private static final String REPORTING_URI = "Reporting.svc/";
    private static final String APPLICATION_URI = "RestApplication.svc/";
    private final HttpClient client;

    public HttpReportingProxy(HttpClient httpClient) {
        this.client = httpClient;
    }

    @Override
    public <TReport extends Report<TResult>, TResult> Future<TResult> populate(Class<TResult> clazz, TReport TReport) {
        String string = this.client.getDslName(TReport.getClass());
        Class<?> clazz2 = clazz.getClass();
        return this.client.sendRequest(JsonSerialization.buildType(clazz2), "Reporting.svc/report/" + string, "PUT", TReport, new int[]{200});
    }

    @Override
    public <TReport extends Report<TResult>, TResult> Future<byte[]> createReport(TReport TReport, String string) {
        String string2 = this.client.getDslName(TReport.getClass());
        return this.client.sendRawRequest("Reporting.svc/report/" + string2 + "/" + string, "PUT", TReport, Utils.acceptAs("application/octet-stream"), new int[]{201});
    }

    public <T extends Searchable> Future<byte[]> olapCube(String string, Specification<T> specification, String string2, Iterable<String> iterable, Iterable<String> iterable2, Iterable<Map.Entry<String, Boolean>> iterable3) {
        if (specification == null) {
            return this.olapCube(string, string2, iterable, iterable2, iterable3);
        }
        String string3 = Utils.buildOlapArguments(iterable, iterable2, iterable3);
        Class<?> clazz = specification.getClass();
        String string4 = this.client.getDslName(clazz.getDeclaringClass());
        String string5 = string4.equals(string) ? string4 + "/" : "";
        return this.client.sendRawRequest("Reporting.svc/olap/" + string + '/' + string5 + clazz.getSimpleName() + '/' + string2 + string3, "PUT", specification, Utils.acceptAs("application/octet-stream"), new int[]{200});
    }

    @Override
    public Future<byte[]> olapCube(String string, String string2, Iterable<String> iterable, Iterable<String> iterable2, Iterable<Map.Entry<String, Boolean>> iterable3) {
        String string3 = Utils.buildOlapArguments(iterable, iterable2, iterable3);
        return this.client.sendRawRequest("Reporting.svc/olap/" + string + '/' + string2 + string3, "GET", null, Utils.acceptAs("application/octet-stream"), new int[]{200});
    }

    public <T extends AggregateRoot> Future<List<History<T>>> getHistory(Class<T> clazz, Iterable<String> iterable) {
        String string = this.client.getDslName(clazz);
        return this.client.sendRequest(JsonSerialization.buildCollectionType(ArrayList.class, JsonSerialization.buildGenericType(History.class, clazz)), "RestApplication.svc/GetRootHistory", "POST", new HistoryArg(string, iterable), new int[]{200});
    }

    @Override
    public <TIdentifiable extends Identifiable> Future<byte[]> findTemplater(Class<TIdentifiable> clazz, String string, String string2, boolean bl) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("file not specified");
        }
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("uri not specified");
        }
        String string3 = this.client.getDslName(clazz);
        return this.client.sendRawRequest("Reporting.svc/templater/" + string + "/" + string3 + "?uri=" + HttpClient.encode(string2), "GET", null, bl ? Utils.acceptAs("application/pdf") : Utils.acceptAs("application/octet-stream"), new int[]{200});
    }

    @Override
    public <TSearchable extends Searchable> Future<byte[]> searchTemplater(Class<TSearchable> clazz, String string, Specification<TSearchable> specification, boolean bl) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("file not specified");
        }
        if (specification == null && clazz == null) {
            throw new IllegalArgumentException("specification or manifest must be provided");
        }
        if (specification == null) {
            String string2 = this.client.getDslName(clazz);
            return this.client.sendRawRequest("Reporting.svc/templater/" + string + "/" + string2, "GET", null, bl ? Utils.acceptAs("application/pdf") : Utils.acceptAs("application/octet-stream"), new int[]{200});
        }
        Class<?> clazz2 = specification.getClass();
        Class<?> clazz3 = clazz2.getDeclaringClass();
        String string3 = this.client.getDslName(clazz3);
        return this.client.sendRawRequest("Reporting.svc/templater/" + string + "/" + string3 + "?specification=" + clazz2.getSimpleName(), "PUT", specification, bl ? Utils.acceptAs("application/pdf") : Utils.acceptAs("application/octet-stream"), new int[]{200});
    }

    private static class HistoryArg {
        public final String Name;
        public final ArrayList<String> Uri;

        private HistoryArg() {
            this.Name = null;
            this.Uri = null;
        }

        public HistoryArg(String string, Iterable<String> iterable) {
            this.Name = string;
            this.Uri = Utils.toArrayList(iterable);
        }
    }
}

