/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonObject;
import com.dslplatform.patterns.ServiceLocator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class JsonReader {
    private final byte[] buffer;
    private final int length;
    private final ServiceLocator locator;
    private int nameStart;
    private int currentIndex;
    private byte last;

    public JsonReader(byte[] byArray, ServiceLocator serviceLocator) {
        this.buffer = byArray;
        this.length = byArray.length;
        this.locator = serviceLocator;
        this.currentIndex = 0;
        this.last = (byte)32;
    }

    public byte read() throws IOException {
        if (this.currentIndex >= this.length) {
            throw new IOException("end of stream");
        }
        this.last = this.buffer[this.currentIndex++];
        return this.last;
    }

    public byte last() {
        return this.last;
    }

    public String readShortValue() throws IOException {
        int n = this.currentIndex - 1;
        while (this.last != 44 && this.last != 125 && this.last != 93) {
            this.read();
        }
        return new String(this.buffer, n, this.currentIndex - n - 1, "ISO-8859-1");
    }

    public String readSimpleString() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        int n = this.currentIndex;
        do {
            this.read();
        } while (this.last != 34);
        return new String(this.buffer, n, this.currentIndex - n - 1, "ISO-8859-1");
    }

    public String readString() throws UnsupportedEncodingException, IOException {
        int n;
        int n2;
        int n3 = this.currentIndex;
        if (this.last != 34) {
            throw new IOException("JSON string must start with a double quote! Instead found: " + this.byteDetails(this.buffer[this.currentIndex - 1]));
        }
        do {
            if (this.currentIndex >= this.length) {
                throw new IOException("JSON string was not closed with a double quote!");
            }
            if ((n2 = this.buffer[this.currentIndex++]) != 34) continue;
            this.last = (byte)34;
            return new String(this.buffer, n3, this.currentIndex - n3 - 1, "ISO-8859-1");
        } while ((n2 ^ 0x5C) >= 1);
        n2 = --this.currentIndex - n3 - 1;
        char[] cArray = new char[n2 + 256];
        for (n = n2; n >= 0; --n) {
            cArray[n] = (char)this.buffer[n3 + n + 1];
        }
        while (true) {
            block26: {
                block25: {
                    if (this.currentIndex >= this.length) {
                        throw new IOException("JSON string was not closed with a double quote!");
                    }
                    if ((n = this.buffer[this.currentIndex++]) == 34) {
                        this.last = (byte)34;
                        return new String(cArray, 0, n2);
                    }
                    if (n2 >= cArray.length - 3) {
                        char[] cArray2 = new char[cArray.length << 1];
                        System.arraycopy(cArray, 0, cArray2, 0, n2);
                        cArray = cArray2;
                    }
                    if (n != 92) break block25;
                    n = this.buffer[this.currentIndex++];
                    switch (n) {
                        case 98: {
                            n = 8;
                            break block26;
                        }
                        case 116: {
                            n = 9;
                            break block26;
                        }
                        case 110: {
                            n = 10;
                            break block26;
                        }
                        case 102: {
                            n = 12;
                            break block26;
                        }
                        case 114: {
                            n = 13;
                            break block26;
                        }
                        case 34: 
                        case 47: 
                        case 92: {
                            break block26;
                        }
                        case 117: {
                            n = (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 12) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 8) + (JsonReader.hexToInt(this.buffer[this.currentIndex++]) << 4) + JsonReader.hexToInt(this.buffer[this.currentIndex++]);
                            break block26;
                        }
                        default: {
                            throw new IOException("Could not parse String, got invalid escape combination '\\" + n + "'");
                        }
                    }
                }
                if ((n & 0x80) != 0) {
                    byte by = this.buffer[this.currentIndex++];
                    if ((n & 0xE0) == 192) {
                        n = ((n & 0x1F) << 6) + (by & 0x3F);
                    } else {
                        byte by2 = this.buffer[this.currentIndex++];
                        if ((n & 0xF0) == 224) {
                            n = ((n & 0xF) << 12) + ((by & 0x3F) << 6) + (by2 & 0x3F);
                        } else {
                            byte by3 = this.buffer[this.currentIndex++];
                            if ((n & 0xF8) != 240) {
                                throw new IOException();
                            }
                            n = ((n & 7) << 18) + ((by & 0x3F) << 12) + ((by2 & 0x3F) << 6) + (by3 & 0x3F);
                            if (n >= 65536) {
                                if (n >= 0x110000) {
                                    throw new IOException();
                                }
                                int n4 = n - 65536;
                                cArray[n2++] = (char)((n4 >>> 10) + 55296);
                                cArray[n2++] = (char)((n4 & 0x3FF) + 56320);
                            }
                        }
                    }
                }
            }
            cArray[n2++] = (char)n;
        }
    }

    private static int hexToInt(byte by) throws IOException {
        if (by >= 48 && by <= 57) {
            return by - 48;
        }
        if (by >= 65 && by <= 70) {
            return by - 55;
        }
        if (by >= 97 && by <= 102) {
            return by - 87;
        }
        throw new IOException("Could not parse unicode escape, expected a hexadecimal digit, got '" + by + "'");
    }

    private String byteDetails(byte by) {
        return "'" + (char)by + "'" + "(" + by + ")";
    }

    public byte getNextToken() throws IOException {
        byte by = this.read();
        while (by == 13 || by == 10 || by == 32 || by == 9) {
            by = this.read();
        }
        return by;
    }

    public byte moveToNextToken() throws IOException {
        byte by = this.last;
        while (by == 13 || by == 10 || by == 32 || by == 9) {
            by = this.read();
        }
        return by;
    }

    public long positionInStream() {
        return this.currentIndex;
    }

    public int fillName() throws IOException {
        if (this.last != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        this.nameStart = this.currentIndex;
        byte by = this.read();
        long l = -2128831035L;
        while (by != 34) {
            l ^= (long)(0xFF & by);
            l *= 16777619L;
            by = this.read();
        }
        if (this.read() != 58) {
            throw new IOException("Expecting ':' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return (int)l;
    }

    public boolean wasLastName(String string) {
        if (string.length() != this.currentIndex - this.nameStart) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == this.buffer[this.nameStart + i]) continue;
            return false;
        }
        return true;
    }

    public byte skip() {
        return this.last;
    }

    public String readNext() {
        return "";
    }

    public byte[] readBase64() throws IOException {
        int n;
        if (this.getNextToken() != 34) {
            throw new IOException("Expecting '\"' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        int n2 = this.currentIndex;
        for (n = this.currentIndex; n < this.buffer.length && this.buffer[n] != 34; ++n) {
        }
        this.last = this.buffer[n];
        this.currentIndex = n;
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw new IOException("Unexpected end of json in collection.");
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return null;
    }

    public boolean wasNull() throws IOException {
        if (this.last == 110) {
            if (this.currentIndex + 2 < this.buffer.length && this.buffer[this.currentIndex] == 117 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 108) {
                this.currentIndex += 3;
                return true;
            }
            throw new IOException("Invalid null value found at: " + this.currentIndex);
        }
        return false;
    }

    public boolean wasTrue() throws IOException {
        if (this.last == 116) {
            if (this.currentIndex + 2 < this.buffer.length && this.buffer[this.currentIndex] == 114 && this.buffer[this.currentIndex + 1] == 117 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 3;
                return true;
            }
            throw new IOException("Invalid boolean value found at: " + this.currentIndex);
        }
        return false;
    }

    public boolean wasFalse() throws IOException {
        if (this.last == 102) {
            if (this.currentIndex + 3 < this.buffer.length && this.buffer[this.currentIndex] == 97 && this.buffer[this.currentIndex + 1] == 108 && this.buffer[this.currentIndex + 2] == 115 && this.buffer[this.currentIndex + 2] == 101) {
                this.currentIndex += 4;
                return false;
            }
            throw new IOException("Invalid boolean value found at: " + this.currentIndex);
        }
        return false;
    }

    public <T> ArrayList<T> deserializeCollection(ReadObject<T> readObject) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        arrayList.add(readObject.read(this));
        while (this.moveToNextToken() == 44) {
            this.getNextToken();
            arrayList.add(readObject.read(this));
        }
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw new IOException("Unexpected end of json in collection.");
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return arrayList;
    }

    public <T> ArrayList<T> deserializeNullableCollection(ReadObject<T> readObject) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.wasNull()) {
            arrayList.add(null);
        } else {
            arrayList.add(readObject.read(this));
        }
        while (this.moveToNextToken() == 44) {
            this.getNextToken();
            if (this.wasNull()) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(readObject.read(this));
        }
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw new IOException("Unexpected end of json in collection.");
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return arrayList;
    }

    public <T extends JsonObject> ArrayList<T> deserializeCollection(ReadJsonObject<T> readJsonObject) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.last == 123) {
            arrayList.add(readJsonObject.deserialize(this, this.locator));
        } else {
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        while (this.moveToNextToken() == 44) {
            if (this.getNextToken() == 123) {
                arrayList.add(readJsonObject.deserialize(this, this.locator));
                continue;
            }
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        if (this.last != 93) {
            if (this.currentIndex >= this.length) {
                throw new IOException("Unexpected end of json in collection.");
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return arrayList;
    }

    public <T extends JsonObject> ArrayList<T> deserializeNullableCollection(ReadJsonObject<T> readJsonObject) throws IOException {
        ArrayList<T> arrayList = new ArrayList<T>();
        if (this.last == 123) {
            arrayList.add(readJsonObject.deserialize(this, this.locator));
        } else if (this.wasNull()) {
            arrayList.add(null);
        } else {
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        while (this.moveToNextToken() == 44) {
            if (this.getNextToken() == 123) {
                arrayList.add(readJsonObject.deserialize(this, this.locator));
                continue;
            }
            if (this.wasNull()) {
                arrayList.add(null);
                continue;
            }
            throw new IOException("Expecting '{' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        if (this.last != 93) {
            if (this.currentIndex >= this.buffer.length) {
                throw new IOException("Unexpected end of json in collection.");
            }
            throw new IOException("Expecting ']' at position " + this.positionInStream() + ". Found " + (char)this.last);
        }
        return arrayList;
    }

    public static interface ReadJsonObject<T extends JsonObject> {
        public T deserialize(JsonReader var1, ServiceLocator var2) throws IOException;
    }

    public static interface ReadObject<T> {
        public T read(JsonReader var1) throws IOException;
    }
}

