/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;

public class NetConverter {
    private static JsonReader.ReadObject<URI> UriReader = new JsonReader.ReadObject<URI>(){

        @Override
        public URI read(JsonReader jsonReader) throws IOException {
            return NetConverter.deserializeUri(jsonReader);
        }
    };
    private static JsonReader.ReadObject<InetAddress> AddressReader = new JsonReader.ReadObject<InetAddress>(){

        @Override
        public InetAddress read(JsonReader jsonReader) throws IOException {
            return NetConverter.deserializeIp(jsonReader);
        }
    };

    public static void serializeNullable(URI uRI, Writer writer) throws IOException {
        if (uRI == null) {
            writer.write("null");
        } else {
            NetConverter.serialize(uRI, writer);
        }
    }

    public static void serialize(URI uRI, Writer writer) throws IOException {
        StringConverter.serialize(uRI.toString(), writer);
    }

    public static URI deserializeUri(JsonReader jsonReader) throws IOException {
        return URI.create(jsonReader.readString());
    }

    public static ArrayList<URI> deserializeUriCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(UriReader);
    }

    public static ArrayList<URI> deserializeUriNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(UriReader);
    }

    public static void serializeNullable(InetAddress inetAddress, Writer writer) throws IOException {
        if (inetAddress == null) {
            writer.write("null");
        } else {
            NetConverter.serialize(inetAddress, writer);
        }
    }

    public static void serialize(InetAddress inetAddress, Writer writer) throws IOException {
        StringConverter.serialize(inetAddress.toString(), writer);
    }

    public static InetAddress deserializeIp(JsonReader jsonReader) throws IOException {
        return InetAddress.getByName(jsonReader.readSimpleString());
    }

    public static ArrayList<InetAddress> deserializeIpCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(AddressReader);
    }

    public static ArrayList<InetAddress> deserializeIpNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(AddressReader);
    }
}

