/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;

public class NumberConverter {
    private static JsonReader.ReadObject<Double> DoubleReader = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDouble(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Float> FloatReader = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeFloat(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Integer> IntReader = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeInt(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Long> LongReader = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeLong(jsonReader);
        }
    };
    private static JsonReader.ReadObject<BigDecimal> DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDecimal(jsonReader);
        }
    };

    public static void serializeNullable(Double d, Writer writer) throws IOException {
        if (d == null) {
            writer.write("null");
        } else {
            writer.write(d.toString());
        }
    }

    public static void serialize(double d, Writer writer) throws IOException {
        writer.write(Double.toString(d));
    }

    public static Double deserializeDouble(JsonReader jsonReader) throws IOException {
        return Double.parseDouble(jsonReader.readShortValue());
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DoubleReader);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DoubleReader);
    }

    public static void serializeNullable(Float f, Writer writer) throws IOException {
        if (f == null) {
            writer.write("null");
        } else {
            writer.write(f.toString());
        }
    }

    public static void serialize(float f, Writer writer) throws IOException {
        writer.write(Float.toString(f));
    }

    public static Float deserializeFloat(JsonReader jsonReader) throws IOException {
        return Float.valueOf(Float.parseFloat(jsonReader.readShortValue()));
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(FloatReader);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(FloatReader);
    }

    public static void serializeNullable(Integer n, Writer writer) throws IOException {
        if (n == null) {
            writer.write("null");
        } else {
            writer.write(n.toString());
        }
    }

    public static void serialize(int n, Writer writer) throws IOException {
        writer.write(Integer.toString(n));
    }

    public static Integer deserializeInt(JsonReader jsonReader) throws IOException {
        return Integer.parseInt(jsonReader.readShortValue());
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(IntReader);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(IntReader);
    }

    public static void serializeNullable(Long l, Writer writer) throws IOException {
        if (l == null) {
            writer.write("null");
        } else {
            writer.write(l.toString());
        }
    }

    public static void serialize(long l, Writer writer) throws IOException {
        writer.write(Long.toString(l));
    }

    public static Long deserializeLong(JsonReader jsonReader) throws IOException {
        return Long.parseLong(jsonReader.readShortValue());
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(LongReader);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(LongReader);
    }

    public static void serializeNullable(BigDecimal bigDecimal, Writer writer) throws IOException {
        if (bigDecimal == null) {
            writer.write("null");
        } else {
            writer.write(bigDecimal.toPlainString());
        }
    }

    public static void serialize(BigDecimal bigDecimal, Writer writer) throws IOException {
        writer.write(bigDecimal.toPlainString());
    }

    public static BigDecimal deserializeDecimal(JsonReader jsonReader) throws IOException {
        return new BigDecimal(jsonReader.readShortValue());
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DecimalReader);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DecimalReader);
    }
}

