/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import android.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

class Utils {
    static final boolean isAndroid = System.getProperty("java.runtime.name").toLowerCase().contains("android");

    Utils() {
    }

    public static <T> ArrayList<T> toArrayList(Iterable<T> iterable) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : iterable) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static List<Map.Entry<String, String>> acceptAs(String string) {
        return Arrays.asList(new AbstractMap.SimpleEntry<String, String>("Accept", string));
    }

    private static void appendOrder(StringBuilder stringBuilder, Iterable<Map.Entry<String, Boolean>> iterable, boolean bl) {
        if (iterable != null && iterable.iterator().hasNext()) {
            stringBuilder.append(bl ? "?order=" : "&order=");
            for (Map.Entry<String, Boolean> entry : iterable) {
                if (entry.getValue() == Boolean.FALSE) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(entry.getKey()).append(',');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
    }

    public static String appendLimitOffsetOrder(String string, Integer n, Integer n2, Iterable<Map.Entry<String, Boolean>> iterable, Boolean bl) {
        boolean bl2;
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl3 = n == null;
        boolean bl4 = n2 == null;
        boolean bl5 = bl2 = bl3 && bl4 && bl != false;
        if (!bl3) {
            stringBuilder.append(bl != false ? "?limit=" : "&limit=").append(n);
        }
        if (!bl4) {
            stringBuilder.append(bl3 && bl != false ? "?offset=" : "&offset=").append(n2);
        }
        Utils.appendOrder(stringBuilder, iterable, bl2);
        return stringBuilder.toString();
    }

    public static String buildOlapArguments(Iterable<String> iterable, Iterable<String> iterable2, Iterable<Map.Entry<String, Boolean>> iterable3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iterable3 != null && iterable3.iterator().hasNext() && !Utils.contains(iterable, iterable3).booleanValue() && !Utils.contains(iterable2, iterable3).booleanValue()) {
            throw new IllegalArgumentException("Order must be an element of dimensions or facts!");
        }
        Utils.appendUrlParam(stringBuilder, "dimensions", iterable);
        Utils.appendUrlParam(stringBuilder, "facts", iterable2);
        if (stringBuilder.length() == 0) {
            throw new IllegalArgumentException("At least one dimension or fact is required");
        }
        Utils.appendUrlParam(stringBuilder, "specification", string);
        Utils.appendOrder(stringBuilder, iterable3, false);
        return stringBuilder.toString();
    }

    public static String buildOlapArguments(Iterable<String> iterable, Iterable<String> iterable2, Iterable<Map.Entry<String, Boolean>> iterable3) {
        StringBuilder stringBuilder = new StringBuilder();
        if (iterable3 != null && iterable3.iterator().hasNext() && !Utils.contains(iterable, iterable3).booleanValue() && !Utils.contains(iterable2, iterable3).booleanValue()) {
            throw new IllegalArgumentException("Order must be an element of dimensions or facts!");
        }
        Utils.appendUrlParam(stringBuilder, "dimensions", iterable);
        Utils.appendUrlParam(stringBuilder, "facts", iterable2);
        if (stringBuilder.length() == 0) {
            throw new IllegalArgumentException("At least one dimension or fact is required");
        }
        Utils.appendOrder(stringBuilder, iterable3, false);
        return stringBuilder.toString();
    }

    private static Boolean contains(Iterable<String> iterable, Iterable<Map.Entry<String, Boolean>> iterable2) {
        if (iterable == null) {
            return false;
        }
        for (Map.Entry<String, Boolean> entry : iterable2) {
            if (Utils.contains(iterable, entry.getKey()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static void appendUrlParam(StringBuilder stringBuilder, String string, Iterable<String> iterable) {
        if (iterable == null) {
            return;
        }
        Iterator<String> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        stringBuilder.append(stringBuilder.length() == 0 ? "?" : "&").append(string).append('=').append(iterator.next());
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(iterator.next());
        }
    }

    private static void appendUrlParam(StringBuilder stringBuilder, String string, String string2) {
        if (string2 == null) {
            return;
        }
        stringBuilder.append(stringBuilder.length() == 0 ? "?" : "&").append(string).append('=').append(string2);
    }

    private static Boolean contains(Iterable<String> iterable, String string) {
        for (String string2 : iterable) {
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        int n;
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    static String base64Encode(byte[] byArray) {
        if (isAndroid) {
            return AndroidEncoding.toBase64(byArray);
        }
        return JavaEncoding.toBase64(byArray);
    }

    static class JavaEncoding {
        JavaEncoding() {
        }

        private static String toBase64(byte[] byArray) {
            return DatatypeConverter.printBase64Binary((byte[])byArray);
        }
    }

    static class AndroidEncoding {
        AndroidEncoding() {
        }

        private static String toBase64(byte[] byArray) {
            return Base64.encodeToString((byte[])byArray, (int)2);
        }
    }
}

