/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import android.util.Base64;
import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.DatatypeConverter;

public class BinaryConverter {
    static final boolean isAndroid = System.getProperty("java.runtime.name").toLowerCase().contains("android");
    private static JsonReader.ReadObject<byte[]> Base64Reader = new JsonReader.ReadObject<byte[]>(){

        @Override
        public byte[] read(JsonReader jsonReader) throws IOException {
            return BinaryConverter.deserialize(jsonReader);
        }
    };

    public static void serialize(byte[] byArray, Writer writer) throws IOException {
        if (byArray == null) {
            writer.write("null");
        } else if (byArray.length == 0) {
            writer.write("\"\"");
        } else if (isAndroid) {
            writer.write(AndroidEncoding.toBase64(byArray));
        } else {
            writer.write(JavaEncoding.toBase64(byArray));
        }
    }

    public static byte[] deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readBase64();
    }

    public static ArrayList<byte[]> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Base64Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<byte[]> collection) throws IOException {
        jsonReader.deserializeCollection(Base64Reader, collection);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<byte[]> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Base64Reader, collection);
    }

    static class JavaEncoding {
        JavaEncoding() {
        }

        private static String toBase64(byte[] byArray) {
            return DatatypeConverter.printBase64Binary((byte[])byArray);
        }
    }

    static class AndroidEncoding {
        AndroidEncoding() {
        }

        private static String toBase64(byte[] byArray) {
            return Base64.encodeToString((byte[])byArray, (int)2);
        }
    }
}

