/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class DateConverter {
    public static final DateTime MIN_DATE_TIME = DateTime.parse((String)"0001-01-01T00:00:00");
    public static final LocalDate MIN_LOCAL_DATE = new LocalDate(1, 1, 1);
    private static JsonReader.ReadObject<DateTime> DateTimeReader = new JsonReader.ReadObject<DateTime>(){

        @Override
        public DateTime read(JsonReader jsonReader) throws IOException {
            return DateConverter.deserializeDateTime(jsonReader);
        }
    };
    private static JsonReader.ReadObject<LocalDate> LocalDateReader = new JsonReader.ReadObject<LocalDate>(){

        @Override
        public LocalDate read(JsonReader jsonReader) throws IOException {
            return DateConverter.deserializeLocalDate(jsonReader);
        }
    };

    public static void serializeNullable(DateTime dateTime, Writer writer) throws IOException {
        if (dateTime == null) {
            writer.write("null");
        } else {
            DateConverter.serialize(dateTime, writer);
        }
    }

    public static void serialize(DateTime dateTime, Writer writer) throws IOException {
        writer.write(34);
        writer.write(dateTime.toString());
        writer.write(34);
    }

    public static DateTime deserializeDateTime(JsonReader jsonReader) throws IOException {
        return DateTime.parse((String)jsonReader.readSimpleString());
    }

    public static ArrayList<DateTime> deserializeDateTimeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DateTimeReader);
    }

    public static void deserializeDateTimeCollection(JsonReader jsonReader, Collection<DateTime> collection) throws IOException {
        jsonReader.deserializeCollection(DateTimeReader, collection);
    }

    public static ArrayList<DateTime> deserializeDateTimeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DateTimeReader);
    }

    public static void deserializeDateTimeNullableCollection(JsonReader jsonReader, Collection<DateTime> collection) throws IOException {
        jsonReader.deserializeNullableCollection(DateTimeReader, collection);
    }

    public static void serializeNullable(LocalDate localDate, Writer writer) throws IOException {
        if (localDate == null) {
            writer.write("null");
        } else {
            DateConverter.serialize(localDate, writer);
        }
    }

    public static void serialize(LocalDate localDate, Writer writer) throws IOException {
        writer.write(34);
        writer.write(localDate.toString());
        writer.write(34);
    }

    public static LocalDate deserializeLocalDate(JsonReader jsonReader) throws IOException {
        String string = jsonReader.readSimpleString();
        return LocalDate.parse((String)string);
    }

    public static ArrayList<LocalDate> deserializeLocalDateCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(LocalDateReader);
    }

    public static void deserializeLocalDateCollection(JsonReader jsonReader, Collection<LocalDate> collection) throws IOException {
        jsonReader.deserializeCollection(LocalDateReader, collection);
    }

    public static ArrayList<LocalDate> deserializeLocalDateNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(LocalDateReader);
    }

    public static void deserializeLocalDateNullableCollection(JsonReader jsonReader, Collection<LocalDate> collection) throws IOException {
        jsonReader.deserializeNullableCollection(LocalDateReader, collection);
    }
}

