/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class GeomConverter {
    private static JsonReader.ReadObject<Point2D> LocationReader = new JsonReader.ReadObject<Point2D>(){

        @Override
        public Point2D read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeLocation(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Point> PointReader = new JsonReader.ReadObject<Point>(){

        @Override
        public Point read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializePoint(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Rectangle2D> RectangleReader = new JsonReader.ReadObject<Rectangle2D>(){

        @Override
        public Rectangle2D read(JsonReader jsonReader) throws IOException {
            return GeomConverter.deserializeRectangle(jsonReader);
        }
    };

    public static void serializeLocationNullable(Point2D point2D, Writer writer) throws IOException {
        if (point2D == null) {
            writer.write("null");
        } else {
            GeomConverter.serializeLocation(point2D, writer);
        }
    }

    public static void serializeLocation(Point2D point2D, Writer writer) throws IOException {
        writer.write("{\"X\":");
        writer.write(Double.toString(point2D.getX()));
        writer.write(",\"Y\":");
        writer.write(Double.toString(point2D.getY()));
        writer.write("}");
    }

    public static Point2D deserializeLocation(JsonReader jsonReader) throws IOException {
        return null;
    }

    public static ArrayList<Point2D> deserializeLocationCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(LocationReader);
    }

    public static void deserializeLocationCollection(JsonReader jsonReader, Collection<Point2D> collection) throws IOException {
        jsonReader.deserializeCollection(LocationReader, collection);
    }

    public static ArrayList<Point2D> deserializeLocationNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(LocationReader);
    }

    public static void deserializeLocationNullableCollection(JsonReader jsonReader, Collection<Point2D> collection) throws IOException {
        jsonReader.deserializeNullableCollection(LocationReader, collection);
    }

    public static void serializePointNullable(Point point, Writer writer) throws IOException {
        if (point == null) {
            writer.write("null");
        } else {
            GeomConverter.serializePoint(point, writer);
        }
    }

    public static void serializePoint(Point point, Writer writer) throws IOException {
        writer.write("{\"X\":");
        writer.write(Integer.toString(point.x));
        writer.write(",\"Y\":");
        writer.write(Integer.toString(point.y));
        writer.write("}");
    }

    public static Point deserializePoint(JsonReader jsonReader) throws IOException {
        return null;
    }

    public static ArrayList<Point> deserializePointCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(PointReader);
    }

    public static void deserializePointCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeCollection(PointReader, collection);
    }

    public static ArrayList<Point> deserializePointNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(PointReader);
    }

    public static void deserializePointNullableCollection(JsonReader jsonReader, Collection<Point> collection) throws IOException {
        jsonReader.deserializeNullableCollection(PointReader, collection);
    }

    public static void serializeRectangleNullable(Rectangle2D rectangle2D, Writer writer) throws IOException {
        if (rectangle2D == null) {
            writer.write("null");
        } else {
            GeomConverter.serializeRectangle(rectangle2D, writer);
        }
    }

    public static void serializeRectangle(Rectangle2D rectangle2D, Writer writer) throws IOException {
        writer.write("{\"X\":");
        writer.write(Double.toString(rectangle2D.getX()));
        writer.write(",\"Y\":");
        writer.write(Double.toString(rectangle2D.getY()));
        writer.write(",\"Width\":");
        writer.write(Double.toString(rectangle2D.getWidth()));
        writer.write(",\"Height\":");
        writer.write(Double.toString(rectangle2D.getHeight()));
        writer.write("}");
    }

    public static Rectangle2D deserializeRectangle(JsonReader jsonReader) throws IOException {
        return null;
    }

    public static ArrayList<Rectangle2D> deserializeRectangleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(RectangleReader);
    }

    public static void deserializeRectangleCollection(JsonReader jsonReader, Collection<Rectangle2D> collection) throws IOException {
        jsonReader.deserializeCollection(RectangleReader, collection);
    }

    public static ArrayList<Rectangle2D> deserializeRectangleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(RectangleReader);
    }

    public static void deserializeRectangleNullableCollection(JsonReader jsonReader, Collection<Rectangle2D> collection) throws IOException {
        jsonReader.deserializeNullableCollection(RectangleReader, collection);
    }
}

