/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.StringConverter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapConverter {
    private static JsonReader.ReadObject<Map<String, String>> MapReader = new JsonReader.ReadObject<Map<String, String>>(){

        @Override
        public Map<String, String> read(JsonReader jsonReader) throws IOException {
            return MapConverter.deserialize(jsonReader);
        }
    };

    public static void serializeNullable(Map<String, String> map, Writer writer) throws IOException {
        if (map == null) {
            writer.write("null");
        } else {
            MapConverter.serialize(map, writer);
        }
    }

    public static void serialize(Map<String, String> map, Writer writer) throws IOException {
        writer.write(123);
        int n = map.size();
        if (n > 0) {
            Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
            Map.Entry<String, String> entry = iterator.next();
            StringConverter.serialize(entry.getKey(), writer);
            writer.write(58);
            StringConverter.serializeNullable(entry.getValue(), writer);
            for (int i = 1; i < n; ++i) {
                writer.write(44);
                entry = iterator.next();
                StringConverter.serialize(entry.getKey(), writer);
                writer.write(58);
                StringConverter.serializeNullable(entry.getValue(), writer);
            }
        }
        writer.write(125);
    }

    public static Map<String, String> deserialize(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() != 123) {
            throw new IOException("Expecting '{' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte by = jsonReader.getNextToken();
        if (by == 125) {
            return hashMap;
        }
        String string = StringConverter.deserialize(jsonReader);
        by = jsonReader.getNextToken();
        if (by != 58) {
            throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        jsonReader.getNextToken();
        String string2 = StringConverter.deserializeNullable(jsonReader);
        hashMap.put(string, string2);
        while ((by = jsonReader.getNextToken()) == 44) {
            jsonReader.getNextToken();
            string = StringConverter.deserialize(jsonReader);
            by = jsonReader.getNextToken();
            if (by != 58) {
                throw new IOException("Expecting ':' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
            }
            jsonReader.getNextToken();
            string2 = StringConverter.deserializeNullable(jsonReader);
            hashMap.put(string, string2);
        }
        if (by != 125) {
            throw new IOException("Expecting '}' at position " + jsonReader.positionInStream() + ". Found " + (char)by);
        }
        return hashMap;
    }

    public static ArrayList<Map<String, String>> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(MapReader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Map<String, String>> collection) throws IOException {
        jsonReader.deserializeCollection(MapReader, collection);
    }

    public static ArrayList<Map<String, String>> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(MapReader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Map<String, String>> collection) throws IOException {
        jsonReader.deserializeNullableCollection(MapReader, collection);
    }
}

