/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class NumberConverter {
    private static JsonReader.ReadObject<Double> DoubleReader = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDouble(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Float> FloatReader = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeFloat(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Integer> IntReader = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeInt(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Long> LongReader = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeLong(jsonReader);
        }
    };
    private static JsonReader.ReadObject<BigDecimal> DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDecimal(jsonReader);
        }
    };

    public static void serializeNullable(Double d, Writer writer) throws IOException {
        if (d == null) {
            writer.write("null");
        } else {
            writer.write(d.toString());
        }
    }

    public static void serialize(double d, Writer writer) throws IOException {
        writer.write(Double.toString(d));
    }

    public static Double deserializeDouble(JsonReader jsonReader) throws IOException {
        return Double.parseDouble(jsonReader.readShortValue());
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DoubleReader);
    }

    public static void deserializeDoubleCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeCollection(DoubleReader, collection);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DoubleReader);
    }

    public static void deserializeDoubleNullableCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeNullableCollection(DoubleReader, collection);
    }

    public static void serializeNullable(Float f, Writer writer) throws IOException {
        if (f == null) {
            writer.write("null");
        } else {
            writer.write(f.toString());
        }
    }

    public static void serialize(float f, Writer writer) throws IOException {
        writer.write(Float.toString(f));
    }

    public static Float deserializeFloat(JsonReader jsonReader) throws IOException {
        return Float.valueOf(Float.parseFloat(jsonReader.readShortValue()));
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(FloatReader);
    }

    public static void deserializeFloatCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeCollection(FloatReader, collection);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(FloatReader);
    }

    public static void deserializeFloatNullableCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeNullableCollection(FloatReader, collection);
    }

    public static void serializeNullable(Integer n, Writer writer) throws IOException {
        if (n == null) {
            writer.write("null");
        } else {
            writer.write(n.toString());
        }
    }

    public static void serialize(int n, Writer writer) throws IOException {
        writer.write(Integer.toString(n));
    }

    public static int deserializeInt(JsonReader jsonReader) throws IOException {
        int n;
        char[] cArray = jsonReader.readNumber();
        int n2 = 0;
        int n3 = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        for (int i = n = cArray[0] == '-' ? 1 : 0; i < n3 && i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return Integer.parseInt(new String(cArray, 0, n3));
            }
            n2 = n2 * 10 + c - 48;
        }
        return n == 0 ? n2 : -n2;
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(IntReader);
    }

    public static void deserializeIntCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeCollection(IntReader, collection);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(IntReader);
    }

    public static void deserializeIntNullableCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeNullableCollection(IntReader, collection);
    }

    public static void serializeNullable(Long l, Writer writer) throws IOException {
        if (l == null) {
            writer.write("null");
        } else {
            writer.write(l.toString());
        }
    }

    public static void serialize(long l, Writer writer) throws IOException {
        writer.write(Long.toString(l));
    }

    public static long deserializeLong(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        long l = 0L;
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        boolean bl = cArray[0] == '-';
        for (int i = 0; i < n && i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return Integer.parseInt(new String(cArray, 0, n));
            }
            l = l * 10L + (long)c - 48L;
        }
        return !bl ? l : -l;
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(LongReader);
    }

    public static void deserializeLongCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeCollection(LongReader, collection);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(LongReader);
    }

    public static void deserializeLongNullableCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeNullableCollection(LongReader, collection);
    }

    public static void serializeNullable(BigDecimal bigDecimal, Writer writer) throws IOException {
        if (bigDecimal == null) {
            writer.write("null");
        } else {
            writer.write(bigDecimal.toString());
        }
    }

    public static void serialize(BigDecimal bigDecimal, Writer writer) throws IOException {
        writer.write(bigDecimal.toString());
    }

    public static BigDecimal deserializeDecimal(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        return new BigDecimal(cArray, 0, jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1);
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(DecimalReader);
    }

    public static void deserializeDecimalCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeCollection(DecimalReader, collection);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(DecimalReader);
    }

    public static void deserializeDecimalNullableCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeNullableCollection(DecimalReader, collection);
    }
}

