/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class StringConverter {
    private static JsonReader.ReadObject<String> Reader = new JsonReader.ReadObject<String>(){

        @Override
        public String read(JsonReader jsonReader) throws IOException {
            return StringConverter.deserialize(jsonReader);
        }
    };

    public static void serializeNullable(String string, Writer writer) throws IOException {
        if (string == null) {
            writer.write("null");
        } else {
            StringConverter.serialize(string, writer);
        }
    }

    public static void serialize(String string, Writer writer) throws IOException {
        writer.write(34);
        block36: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\u0000': {
                    writer.write("\\u0000");
                    continue block36;
                }
                case '\u0001': {
                    writer.write("\\u0001");
                    continue block36;
                }
                case '\u0002': {
                    writer.write("\\u0002");
                    continue block36;
                }
                case '\u0003': {
                    writer.write("\\u0003");
                    continue block36;
                }
                case '\u0004': {
                    writer.write("\\u0004");
                    continue block36;
                }
                case '\u0005': {
                    writer.write("\\u0005");
                    continue block36;
                }
                case '\u0006': {
                    writer.write("\\u0006");
                    continue block36;
                }
                case '\u0007': {
                    writer.write("\\u0007");
                    continue block36;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block36;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block36;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block36;
                }
                case '\u000b': {
                    writer.write("\\u000B");
                    continue block36;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block36;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block36;
                }
                case '\u000e': {
                    writer.write("\\u000E");
                    continue block36;
                }
                case '\u000f': {
                    writer.write("\\u000F");
                    continue block36;
                }
                case '\u0010': {
                    writer.write("\\u0010");
                    continue block36;
                }
                case '\u0011': {
                    writer.write("\\u0011");
                    continue block36;
                }
                case '\u0012': {
                    writer.write("\\u0012");
                    continue block36;
                }
                case '\u0013': {
                    writer.write("\\u0013");
                    continue block36;
                }
                case '\u0014': {
                    writer.write("\\u0014");
                    continue block36;
                }
                case '\u0015': {
                    writer.write("\\u0015");
                    continue block36;
                }
                case '\u0016': {
                    writer.write("\\u0016");
                    continue block36;
                }
                case '\u0017': {
                    writer.write("\\u0017");
                    continue block36;
                }
                case '\u0018': {
                    writer.write("\\u0018");
                    continue block36;
                }
                case '\u0019': {
                    writer.write("\\u0019");
                    continue block36;
                }
                case '\u001a': {
                    writer.write("\\u001A");
                    continue block36;
                }
                case '\u001b': {
                    writer.write("\\u001B");
                    continue block36;
                }
                case '\u001c': {
                    writer.write("\\u001C");
                    continue block36;
                }
                case '\u001d': {
                    writer.write("\\u001D");
                    continue block36;
                }
                case '\u001e': {
                    writer.write("\\u001E");
                    continue block36;
                }
                case '\u001f': {
                    writer.write("\\u001F");
                    continue block36;
                }
                case '\\': {
                    writer.write("\\\\");
                    continue block36;
                }
                case '\"': {
                    writer.write("\\\"");
                    continue block36;
                }
                default: {
                    writer.write(c);
                }
            }
        }
        writer.write(34);
    }

    public static String deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readString();
    }

    public static String deserializeNullable(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 110) {
            if (!jsonReader.wasNull()) {
                throw new IOException("Expecting 'null' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
            }
            return null;
        }
        return jsonReader.readString();
    }

    public static ArrayList<String> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollection(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeCollection(Reader, collection);
    }

    public static ArrayList<String> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollection(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeNullableCollection(Reader, collection);
    }
}

