/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.ApplicationProxy;
import com.dslplatform.client.ClientDomainEventStore;
import com.dslplatform.client.CrudProxy;
import com.dslplatform.client.DomainProxy;
import com.dslplatform.client.HttpApplicationProxy;
import com.dslplatform.client.HttpClient;
import com.dslplatform.client.HttpCrudProxy;
import com.dslplatform.client.HttpDomainProxy;
import com.dslplatform.client.HttpHeaderProvider;
import com.dslplatform.client.HttpReportingProxy;
import com.dslplatform.client.HttpStandardProxy;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.MapServiceLocator;
import com.dslplatform.client.ReportingProxy;
import com.dslplatform.client.SettingsHeaderProvider;
import com.dslplatform.client.StandardProxy;
import com.dslplatform.patterns.DomainEventStore;
import com.dslplatform.patterns.ServiceLocator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static ServiceLocator staticLocator;
    private static final Properties versionInfo;

    public static ServiceLocator getLocator() {
        if (staticLocator == null) {
            throw new RuntimeException("Bootstrap has not been initialized, call Bootstrap.init");
        }
        return staticLocator;
    }

    public static ServiceLocator init(Properties properties, Map<Class<?>, Object> map) throws IOException {
        return Bootstrap.init(properties, new MapServiceLocator(map));
    }

    public static ServiceLocator init(Properties properties) throws IOException {
        return Bootstrap.init(properties, new MapServiceLocator());
    }

    public static ServiceLocator init(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Provided input stream was null.");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        return Bootstrap.init(properties, new MapServiceLocator());
    }

    private static ServiceLocator init(Properties properties, MapServiceLocator mapServiceLocator) throws IOException {
        HttpHeaderProvider httpHeaderProvider;
        ExecutorService executorService;
        Logger logger;
        if (properties == null) {
            throw new IOException("Provided properties was null.");
        }
        JsonSerialization jsonSerialization = new JsonSerialization(mapServiceLocator);
        if (mapServiceLocator.contains(Logger.class)) {
            logger = mapServiceLocator.resolve(Logger.class);
        } else {
            logger = LoggerFactory.getLogger((String)"dsl-client-http");
            mapServiceLocator.register(Logger.class, logger);
        }
        mapServiceLocator.register(Properties.class, properties);
        if (mapServiceLocator.contains(ExecutorService.class)) {
            executorService = mapServiceLocator.resolve(ExecutorService.class);
        } else {
            executorService = Executors.newCachedThreadPool();
            mapServiceLocator.register(ExecutorService.class, executorService);
        }
        if (mapServiceLocator.contains(HttpHeaderProvider.class)) {
            httpHeaderProvider = mapServiceLocator.resolve(HttpHeaderProvider.class);
        } else {
            httpHeaderProvider = new SettingsHeaderProvider(properties);
            mapServiceLocator.register(HttpHeaderProvider.class, httpHeaderProvider);
        }
        HttpClient httpClient = new HttpClient(properties, jsonSerialization, mapServiceLocator, logger, httpHeaderProvider, executorService);
        HttpDomainProxy httpDomainProxy = new HttpDomainProxy(httpClient);
        mapServiceLocator.register(JsonSerialization.class, jsonSerialization).register(HttpClient.class, httpClient).register(ApplicationProxy.class, new HttpApplicationProxy(httpClient)).register(CrudProxy.class, HttpCrudProxy.class).register(DomainProxy.class, httpDomainProxy).register(StandardProxy.class, new HttpStandardProxy(httpClient, executorService)).register(ReportingProxy.class, new HttpReportingProxy(httpClient, executorService, jsonSerialization)).register(DomainEventStore.class, new ClientDomainEventStore(httpDomainProxy));
        staticLocator = mapServiceLocator;
        return staticLocator;
    }

    public static ServiceLocator init(String string) throws IOException {
        if (string == null) {
            throw new IOException("Provided path to properties file was null.");
        }
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            ServiceLocator serviceLocator = Bootstrap.init(fileInputStream);
            return serviceLocator;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private static final String getVersionInfo(String string) {
        if (versionInfo.isEmpty()) {
            try {
                versionInfo.load(Bootstrap.class.getResourceAsStream("dsl-client.properties"));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return versionInfo.getProperty(string);
    }

    public static String getVersion() {
        return Bootstrap.getVersionInfo("version");
    }

    public static String getReleaseDate() {
        return Bootstrap.getVersionInfo("date");
    }

    public static void main(String[] stringArray) {
        String string = String.format("dsl-client-java-%s.jar (released on: %s)", Bootstrap.getVersion(), Bootstrap.getReleaseDate());
        System.out.println();
        System.out.println(string);
        System.out.println(string.replaceAll(".", "-"));
        System.out.println();
        System.out.println("This is the Java version of the DSL Platform client library");
        System.out.println("and is not indented to be run as a standalone application.");
        System.out.println();
        System.out.println("For more information, visit https://dsl-platform.com/");
        System.out.println();
    }

    static {
        versionInfo = new Properties();
    }
}

