/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import com.dslplatform.client.HttpHeaderProvider;
import com.dslplatform.client.JsonSerialization;
import com.dslplatform.client.Utils;
import com.dslplatform.client.exceptions.HttpException;
import com.dslplatform.client.exceptions.HttpSecurityException;
import com.dslplatform.client.exceptions.HttpServerErrorException;
import com.dslplatform.client.exceptions.HttpUnexpectedCodeException;
import com.dslplatform.client.json.JsonObject;
import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.patterns.ServiceLocator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;

class HttpClient {
    private final Logger logger;
    private final JsonSerialization jsonDeserialization;
    private final ServiceLocator locator;
    private final HttpHeaderProvider headerProvider;
    private final ExecutorService executorService;
    private final String domainPrefix;
    private final int domainPrefixLength;
    private final String[] remoteUrls;
    private final SSLSocketFactory SSL_SOCKET_FACTORY;
    private static final String MIME_TYPE = "application/json";
    private int currentUrl;
    private static ThreadLocal<JsonWriter> perThreadBuffer = new ThreadLocal<JsonWriter>(){

        @Override
        protected synchronized JsonWriter initialValue() {
            return new JsonWriter();
        }
    };
    private static final List<Map.Entry<String, String>> emptyHeaders = new ArrayList<Map.Entry<String, String>>(0);
    private static final ConcurrentHashMap<Class<?>, JsonReader.ReadJsonObject<JsonObject>> jsonReaderes = new ConcurrentHashMap();

    static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public HttpClient(Properties properties, JsonSerialization jsonSerialization, ServiceLocator serviceLocator, Logger logger, HttpHeaderProvider httpHeaderProvider, ExecutorService executorService) {
        this.logger = logger;
        this.jsonDeserialization = jsonSerialization;
        this.locator = serviceLocator;
        this.executorService = executorService;
        this.remoteUrls = properties.getProperty("api-url").split(",\\s+");
        this.SSL_SOCKET_FACTORY = this.createSSLSocketFactory(properties);
        this.domainPrefix = properties.getProperty("package-name");
        if (this.domainPrefix == null) {
            throw new IllegalArgumentException("package-name is missing from provided configuration. It is used to specify root namespace");
        }
        this.domainPrefixLength = this.domainPrefix.length() + 1;
        this.headerProvider = httpHeaderProvider;
    }

    private SSLSocketFactory createSSLSocketFactory(Properties properties) {
        String string = properties.getProperty("trustStore");
        String string2 = properties.getProperty("trustStorePassword");
        if (string != null && string2 != null) {
            return this.createSSLSocketFactory(string, string2);
        }
        String string3 = System.getenv("trustStore");
        String string4 = System.getenv("trustStorePassword");
        if (string3 != null && string4 != null) {
            return this.createSSLSocketFactory(string3, string4);
        }
        return null;
    }

    private SSLSocketFactory createSSLSocketFactory(String string, String string2) {
        String string3 = KeyStore.getDefaultType();
        try {
            if (string3.equals("jks")) {
                SSLContext sSLContext = SSLContext.getInstance("TLS");
                KeyStore keyStore = KeyStore.getInstance(string3);
                keyStore.load(HttpClient.class.getResourceAsStream(string), string2.toCharArray());
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
                sSLContext.init(null, trustManagerArray, null);
                return sSLContext.getSocketFactory();
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public String getDslName(Class<?> clazz) {
        String string = clazz.getName();
        if (string.startsWith(this.domainPrefix)) {
            return string.substring(this.domainPrefixLength);
        }
        throw new RuntimeException(string + " is not defined for package " + this.domainPrefix);
    }

    private static boolean contains(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    private <TArgument> byte[] doRawRequest(String string, List<Map.Entry<String, String>> list, String string2, TArgument TArgument, int[] nArray, long l) throws IOException {
        Object object;
        byte[] byArray;
        if (TArgument == null) {
            byArray = null;
            this.logger.debug("Sending request [{}]: {}", (Object)string2, (Object)string);
        } else {
            if (TArgument instanceof JsonObject) {
                object = perThreadBuffer.get();
                JsonObject jsonObject = (JsonObject)TArgument;
                jsonObject.serialize((Writer)object, true);
                byArray = ((JsonWriter)object).toBytes();
            } else {
                byArray = JsonSerialization.serializeBytes(TArgument);
            }
            this.logger.debug("Sending request [{}]: {}, content size: {} bytes", new Object[]{string2, string, byArray.length});
        }
        object = this.transmit(string, list, string2, byArray, 2);
        if (this.logger.isDebugEnabled()) {
            long l2 = System.currentTimeMillis() - l;
            this.logger.debug("Received response [{}, {} bytes] in {} ms", new Object[]{((Response)object).code, ((Response)object).body.length, l2});
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Received response body: {}", (Object)((Response)object).bodyToString());
            }
        }
        if (((Response)object).code == 403 || ((Response)object).code == 401) {
            throw new HttpSecurityException(((Response)object).bodyToString(), ((Response)object).code, ((Response)object).connection.getHeaderFields());
        }
        if (((Response)object).code >= 500) {
            throw new HttpServerErrorException(((Response)object).bodyToString(), ((Response)object).code, ((Response)object).connection.getHeaderFields());
        }
        if (nArray != null && !HttpClient.contains(nArray, ((Response)object).code)) {
            throw new HttpUnexpectedCodeException(((Response)object).bodyToString(), nArray, ((Response)object).code, ((Response)object).connection.getHeaderFields());
        }
        if (nArray == null && ((Response)object).code >= 400) {
            throw new HttpException(((Response)object).bodyToString(), ((Response)object).code, ((Response)object).connection.getHeaderFields());
        }
        return ((Response)object).body;
    }

    public <TArgument> Future<byte[]> sendRawRequest(final String string, final String string2, final TArgument TArgument, final List<Map.Entry<String, String>> list, final int[] nArray) {
        final long l = System.currentTimeMillis();
        return this.executorService.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws IOException {
                return HttpClient.this.doRawRequest(string, list, string2, TArgument, nArray, l);
            }
        });
    }

    private static JsonReader.ReadJsonObject<JsonObject> getReader(Class<?> clazz) {
        try {
            JsonReader.ReadJsonObject readJsonObject = jsonReaderes.get(clazz);
            if (readJsonObject == null) {
                readJsonObject = (JsonReader.ReadJsonObject)clazz.getField("JSON_READER").get(null);
                jsonReaderes.putIfAbsent(clazz, readJsonObject);
            }
            return readJsonObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <TArgument, TResult> Future<TResult> sendRequest(final Class<TResult> clazz, final String string, final String string2, final TArgument TArgument, final int[] nArray) {
        final long l = System.currentTimeMillis();
        return this.executorService.submit(new Callable<TResult>(){

            @Override
            public TResult call() throws IOException {
                JsonReader jsonReader;
                JsonReader.ReadJsonObject readJsonObject;
                byte[] byArray = HttpClient.this.doRawRequest(string, emptyHeaders, string2, TArgument, nArray, l);
                if (JsonObject.class.isAssignableFrom(clazz) && (readJsonObject = HttpClient.getReader(clazz)) != null && (jsonReader = new JsonReader(byArray, HttpClient.this.locator)).getNextToken() == 123) {
                    return readJsonObject.deserialize(jsonReader, HttpClient.this.locator);
                }
                return HttpClient.this.jsonDeserialization.deserialize(clazz, byArray);
            }
        });
    }

    public <TArgument, TResult> Future<List<TResult>> sendCollectionRequest(final Class<TResult> clazz, final String string, final String string2, final TArgument TArgument, final int[] nArray) {
        final long l = System.currentTimeMillis();
        return this.executorService.submit(new Callable<List<TResult>>(){

            @Override
            public List<TResult> call() throws IOException {
                JsonReader jsonReader;
                JsonReader.ReadJsonObject readJsonObject;
                byte[] byArray = HttpClient.this.doRawRequest(string, emptyHeaders, string2, TArgument, nArray, l);
                if (JsonObject.class.isAssignableFrom(clazz) && (readJsonObject = HttpClient.getReader(clazz)) != null && (jsonReader = new JsonReader(byArray, HttpClient.this.locator)).getNextToken() == 91) {
                    if (jsonReader.getNextToken() == 93) {
                        return new ArrayList();
                    }
                    return jsonReader.deserializeCollection(readJsonObject);
                }
                return (List)HttpClient.this.jsonDeserialization.deserialize(JsonSerialization.buildCollectionType(ArrayList.class, clazz), byArray);
            }
        });
    }

    private Response transmit(String string, List<Map.Entry<String, String>> list, String string2, byte[] byArray, int n) throws IOException {
        IOException iOException = null;
        int n2 = this.remoteUrls.length + this.currentUrl;
        for (int i = this.currentUrl; i < n2; ++i) {
            try {
                URL uRL = new URL(this.remoteUrls[i % this.remoteUrls.length] + string);
                Response response = this.transmit(uRL, list, string2, byArray);
                if (response.code == 409 && n > 0) {
                    return this.transmit(string, list, string2, byArray, n - 1);
                }
                if (response.code < 500) {
                    return response;
                }
                this.logger.error("At {} [{}] {}", new Object[]{uRL, response.code, response.bodyToString()});
                this.logger.error("Error connecting to {}. Trying next server if exists...", (Object)uRL);
                iOException = new IOException(response.bodyToString());
            }
            catch (ConnectException connectException) {
                if (n > 0) {
                    return this.transmit(string, list, string2, byArray, n - 1);
                }
                this.logger.error("At {} {}. Trying next server if exists...", (Object)string, (Object)connectException.getMessage());
                iOException = connectException;
            }
            catch (IOException iOException2) {
                this.logger.error("IOException {} to {}. Trying next server if exists...", (Object)iOException2.getMessage(), (Object)string);
                iOException = iOException2;
            }
            ++this.currentUrl;
            this.currentUrl %= this.remoteUrls.length;
        }
        throw iOException;
    }

    private Response transmit(URL uRL, List<Map.Entry<String, String>> list, String string, byte[] byArray) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (httpURLConnection instanceof HttpsURLConnection && this.SSL_SOCKET_FACTORY != null) {
            ((HttpsURLConnection)httpURLConnection).setSSLSocketFactory(this.SSL_SOCKET_FACTORY);
        }
        httpURLConnection.setRequestMethod(string);
        httpURLConnection.setRequestProperty("Accept", MIME_TYPE);
        httpURLConnection.setRequestProperty("Content-Type", MIME_TYPE);
        for (Map.Entry<String, String> entry : list) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        this.logger.debug("{} {}", (Object)string, (Object)uRL.toString());
        for (Map.Entry<String, String> entry : this.headerProvider.getHeaders()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.logger.isTraceEnabled()) {
            for (Map.Entry<String, Object> entry : httpURLConnection.getRequestProperties().entrySet()) {
                this.logger.trace("{}: {}", (Object)entry.getKey(), entry.getValue());
            }
        }
        if (byArray != null) {
            httpURLConnection.setDoOutput(true);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Adding payload: {}", (Object)new String(byArray, "UTF-8"));
            }
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
            httpURLConnection.getOutputStream().write(byArray);
            httpURLConnection.getOutputStream().close();
        }
        return new Response(httpURLConnection);
    }

    static class Response {
        public final int code;
        public final byte[] body;
        public final HttpURLConnection connection;

        public Response(HttpURLConnection httpURLConnection) throws IOException {
            this.code = httpURLConnection.getResponseCode();
            int n = httpURLConnection.getContentLength();
            if (this.code < 300 && n >= 0) {
                this.body = new byte[n];
                for (int i = 0; i < this.body.length; i += httpURLConnection.getInputStream().read(this.body, i, this.body.length - i)) {
                }
            } else {
                this.body = this.code < 400 ? Utils.inputStreamToByteArray(httpURLConnection.getInputStream()) : Utils.inputStreamToByteArray(httpURLConnection.getErrorStream());
            }
            this.connection = httpURLConnection;
        }

        public String bodyToString() {
            try {
                return this.body == null ? "" : new String(this.body, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }
}

