/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import com.dslplatform.client.Utils;
import com.dslplatform.patterns.AggregateRoot;
import com.dslplatform.patterns.History;
import com.dslplatform.patterns.ServiceLocator;
import com.dslplatform.patterns.Snapshot;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JsonSerialization {
    private static final String TEXT_NODE_TAG = "#text";
    private static final String COMMENT_NODE_TAG = "#comment";
    private static final String CDATA_NODE_TAG = "#cdata-section";
    private static final JsonSerializer<LocalDate> dateSerializer = new JsonSerializer<LocalDate>(){

        public void serialize(LocalDate localDate, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(localDate.toString());
        }
    };
    private static final JsonDeserializer<LocalDate> dateDeserializer = new JsonDeserializer<LocalDate>(){

        public LocalDate deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return DateTime.parse((String)jsonParser.getValueAsString()).toLocalDate();
        }
    };
    private static final JsonSerializer<DateTime> timestampSerializer = new JsonSerializer<DateTime>(){

        public void serialize(DateTime dateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeString(dateTime.toString());
        }
    };
    private static final JsonDeserializer<DateTime> timestampDeserializer = new JsonDeserializer<DateTime>(){

        public DateTime deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return DateTime.parse((String)jsonParser.getValueAsString());
        }
    };
    private static final JsonSerializer<Element> xmlSerializer = new JsonSerializer<Element>(){

        public void serialize(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            JsonSerialization.trimWhitespaceTextNodes(element);
            if (element == null) {
                return;
            }
            element.getChildNodes();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(element.getNodeName(), JsonSerialization.buildFromXml(element));
            jsonGenerator.writeObject(hashMap);
        }
    };
    private static final JsonDeserializer<Element> xmlDeserializer = new JsonDeserializer<Element>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Element deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Element element;
            Document document;
            HashMap hashMap = (HashMap)jsonParser.readValueAs(HashMap.class);
            if (hashMap == null) {
                return null;
            }
            Set set = hashMap.keySet();
            if (set.size() > 1) {
                throw new IOException("Invalid XML. Expecting root element");
            }
            String string = (String)set.iterator().next();
            try {
                6 var8_6 = this;
                synchronized (var8_6) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    document = documentBuilder.newDocument();
                    element = document.createElement(string);
                    document.appendChild(element);
                }
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
            JsonSerialization.buildXmlFromHashMap(document, element, hashMap.get(string));
            return element;
        }
    };
    private static final SimpleModule serializationModule = new SimpleModule("SerializationModule", new Version(1, 0, 0, "SNAPSHOT", "com.dslplatform", "dsl-client-java")).addSerializer(LocalDate.class, dateSerializer).addSerializer(Element.class, xmlSerializer).addSerializer(DateTime.class, timestampSerializer);
    private static final ObjectMapper serializationMapper = new ObjectMapper().registerModule((Module)serializationModule).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private static final TypeFactory typeFactory = serializationMapper.getTypeFactory();
    private final ObjectMapper deserializationMapper;
    private static final SimpleModule deserializationModule = new SimpleModule("DeserializationModule", new Version(1, 0, 0, "SNAPSHOT", "com.dslplatform", "dsl-client-java")).addDeserializer(LocalDate.class, dateDeserializer).addDeserializer(DateTime.class, timestampDeserializer).addDeserializer(Element.class, xmlDeserializer);
    private static ObjectMapper staticDeserializationMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)deserializationModule);

    private static void trimWhitespaceTextNodes(Node node) {
        if (node != null && node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node node2 = node.getChildNodes().item(i);
                if (node2.getNodeType() == 3 && node2.getNodeValue().trim().length() == 0) {
                    node.removeChild(node2);
                }
                JsonSerialization.trimWhitespaceTextNodes(node.getChildNodes().item(i));
            }
        }
    }

    private static Object buildFromXml(Element element) {
        Object object;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            String string = node.getNodeName();
            if (!linkedHashMap.containsKey(string)) {
                linkedHashMap.put(string, new LinkedList());
            }
            ((LinkedList)linkedHashMap.get(string)).add(node);
        }
        if (n == 0 && element.getAttributes().getLength() == 0) {
            return !"".equals(element.getTextContent()) ? element.getTextContent() : null;
        }
        LinkedHashMap<String, Object> linkedHashMap2 = new LinkedHashMap<String, Object>();
        int n2 = element.getAttributes().getLength();
        for (int i = 0; i < n2; ++i) {
            Node object22 = element.getAttributes().item(i);
            linkedHashMap2.put("@" + object22.getNodeName(), object22.getNodeValue());
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object = new Object[((LinkedList)entry.getValue()).size()];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                Node node = (Node)((LinkedList)entry.getValue()).get(i);
                object[i] = node instanceof Element ? JsonSerialization.buildFromXml((Element)node) : (!"".equals(node.getNodeValue()) ? node.getNodeValue() : null);
            }
            linkedHashMap2.put((String)entry.getKey(), ((Object[])object).length > 1 ? object : object[0]);
        }
        if (linkedHashMap2.size() == 1 && linkedHashMap.keySet().iterator().hasNext()) {
            String string = (String)linkedHashMap.keySet().iterator().next();
            if (string.equals(TEXT_NODE_TAG)) {
                return linkedHashMap2.get(string);
            }
            Object v = linkedHashMap2.get(string);
            if (v instanceof HashMap && ((HashMap)(object = (HashMap)v)).size() == 1 && ((HashMap)object).containsKey(string)) {
                return object;
            }
        }
        return linkedHashMap2;
    }

    private static void buildXmlFromHashMap(Document document, Element element, Object object) {
        if (object instanceof HashMap) {
            HashMap hashMap = (HashMap)object;
            for (Map.Entry entry : hashMap.entrySet()) {
                Node node;
                String string = (String)entry.getKey();
                if (string.startsWith("@")) {
                    element.setAttribute(string.substring(1), entry.getValue().toString());
                    continue;
                }
                if (string.startsWith("#")) {
                    if (string.equals(TEXT_NODE_TAG)) {
                        if (entry.getValue() instanceof List) {
                            JsonSerialization.buildTextNodeList(document, element, (List)entry.getValue());
                            continue;
                        }
                        node = document.createTextNode(entry.getValue().toString());
                        element.appendChild(node);
                        continue;
                    }
                    if (string.equals(CDATA_NODE_TAG)) {
                        if (entry.getValue() instanceof List) {
                            JsonSerialization.buildCDataList(document, element, (List)entry.getValue());
                            continue;
                        }
                        node = document.createCDATASection(entry.getValue().toString());
                        element.appendChild(node);
                        continue;
                    }
                    if (!string.equals(COMMENT_NODE_TAG)) continue;
                    if (entry.getValue() instanceof List) {
                        JsonSerialization.buildCommentList(document, element, (List)entry.getValue());
                        continue;
                    }
                    node = document.createComment(entry.getValue().toString());
                    element.appendChild(node);
                    continue;
                }
                node = document.createElement(string);
                element.appendChild(node);
                JsonSerialization.buildXmlFromHashMap(document, node, entry.getValue());
            }
        } else if (object instanceof List) {
            JsonSerialization.buildXmlFromJsonArray(document, element, (List)object);
        } else if (object != null) {
            element.setTextContent(object.toString());
        }
    }

    private static void buildTextNodeList(Document document, Node node, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
        }
        node.appendChild(document.createTextNode(stringBuilder.toString()));
    }

    private static void buildCDataList(Document document, Node node, List<String> list) {
        for (String string : list) {
            node.appendChild(document.createCDATASection(string));
        }
    }

    private static void buildCommentList(Document document, Node node, List<String> list) {
        for (String string : list) {
            node.appendChild(document.createComment(string));
        }
    }

    private static void buildXmlFromJsonArray(Document document, Node node, List<Object> list) {
        Node node2 = node.getParentNode();
        JsonSerialization.buildXmlFromHashMap(document, (Element)node, list.get(0));
        for (Object object : list.subList(1, list.size())) {
            Element element = document.createElement(node.getNodeName());
            node2.appendChild(element);
            JsonSerialization.buildXmlFromHashMap(document, element, object);
        }
    }

    public static JavaType buildType(Class<?> clazz) {
        return typeFactory.constructType(clazz);
    }

    public static JavaType buildGenericType(Class<?> clazz, Class<?> ... classArray) {
        return typeFactory.constructParametricType(clazz, (Class[])classArray);
    }

    public static JavaType buildCollectionType(Class<? extends Collection> clazz, JavaType javaType) {
        return typeFactory.constructCollectionType(clazz, javaType);
    }

    public static JavaType buildCollectionType(Class<? extends Collection> clazz, Class<?> clazz2) {
        return typeFactory.constructCollectionType(clazz, clazz2);
    }

    JsonSerialization(ServiceLocator serviceLocator) {
        this.deserializationMapper = JsonSerialization.makeDeserializationObjectMapper(serviceLocator);
    }

    public <T> T deserialize(JavaType javaType, String string) throws IOException {
        return (T)this.deserializationMapper.readValue(string, javaType);
    }

    public <T> T deserialize(JavaType javaType, byte[] byArray) throws IOException {
        return (T)this.deserializationMapper.readValue(byArray, javaType);
    }

    public <T> T deserialize(Class<T> clazz, byte[] byArray) throws IOException {
        return (T)this.deserializationMapper.readValue(byArray, clazz);
    }

    public <T> T deserialize(JavaType javaType, InputStream inputStream) throws IOException {
        return (T)this.deserializationMapper.readValue(inputStream, javaType);
    }

    public <T extends AggregateRoot> List<History<T>> deserializeHistoryList(Class<T> clazz, byte[] byArray) throws IOException {
        JavaType javaType = JsonSerialization.buildCollectionType(ArrayList.class, JsonSerialization.buildGenericType(HistoryDelegate.class, clazz));
        List list = (List)this.deserializationMapper.readValue(byArray, javaType);
        ArrayList<History<T>> arrayList = new ArrayList<History<T>>(list.size());
        for (HistoryDelegate historyDelegate : list) {
            List list2 = historyDelegate.Snapshots;
            ArrayList arrayList2 = new ArrayList(list2.size());
            for (SnapshotDelegate snapshotDelegate : list2) {
                arrayList2.add(new Snapshot(snapshotDelegate.At, snapshotDelegate.Action, snapshotDelegate.Value));
            }
            arrayList.add(new History(arrayList2));
        }
        return arrayList;
    }

    public static <T> T deserialize(Class<T> clazz, String string) throws IOException {
        return (T)staticDeserializationMapper.readValue(string, clazz);
    }

    public static <T> ArrayList<T> deserializeCollection(Class<T> clazz, String string) throws IOException {
        return (ArrayList)staticDeserializationMapper.readValue(string, (JavaType)typeFactory.constructCollectionType(ArrayList.class, clazz));
    }

    public static String serialize(Object object) throws IOException {
        return serializationMapper.writer().writeValueAsString(object);
    }

    public static byte[] serializeBytes(Object object) throws IOException {
        return serializationMapper.writer().writeValueAsBytes(object);
    }

    public static void serialize(OutputStream outputStream, Object object) throws IOException {
        serializationMapper.writer().writeValue(outputStream, object);
    }

    public static void serialize(Writer writer, Object object) throws IOException {
        serializationMapper.writer().writeValue(writer, object);
    }

    private static ObjectMapper makeDeserializationObjectMapper(ServiceLocator serviceLocator) {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)deserializationModule).setInjectableValues((InjectableValues)new InjectableValues.Std().addValue("_serviceLocator", (Object)serviceLocator));
    }

    public static <T> T deserialize(JavaType javaType, String string, ServiceLocator serviceLocator) throws IOException {
        return (T)JsonSerialization.makeDeserializationObjectMapper(serviceLocator).readValue(string, javaType);
    }

    public static <T> T deserialize(JavaType javaType, byte[] byArray, ServiceLocator serviceLocator) throws IOException {
        return (T)JsonSerialization.makeDeserializationObjectMapper(serviceLocator).readValue(byArray, javaType);
    }

    public static <T> T deserialize(JavaType javaType, InputStream inputStream, ServiceLocator serviceLocator) throws IOException {
        return (T)JsonSerialization.makeDeserializationObjectMapper(serviceLocator).readValue(inputStream, javaType);
    }

    private static void addPlatformDependentSerializerModules(SimpleModule simpleModule) {
        if (Utils.isAndroid) {
            AndroidConverters.initAndroidSerializers(simpleModule);
        } else {
            JavaConverters.initJavaSerializers(simpleModule);
        }
    }

    private static void addPlatformDependentDeserializerModules(SimpleModule simpleModule) {
        if (Utils.isAndroid) {
            AndroidConverters.initAndroidDeserializers(simpleModule);
        } else {
            JavaConverters.initJavaDeserializers(simpleModule);
        }
    }

    static {
        JsonSerialization.addPlatformDependentDeserializerModules(deserializationModule);
        JsonSerialization.addPlatformDependentSerializerModules(serializationModule);
    }

    private static class SnapshotDelegate<T extends AggregateRoot> {
        public final DateTime At;
        public final String Action;
        public final T Value;

        private SnapshotDelegate() {
            this(null, null, null);
        }

        public SnapshotDelegate(DateTime dateTime, String string, T t) {
            this.At = dateTime;
            this.Action = string;
            this.Value = t;
        }
    }

    private static class HistoryDelegate<T extends AggregateRoot> {
        public final List<SnapshotDelegate<T>> Snapshots = null;

        private HistoryDelegate() {
        }
    }

    static class AndroidConverters {
        AndroidConverters() {
        }

        private static void initAndroidSerializers(SimpleModule simpleModule) {
            simpleModule.addSerializer(Point.class, (JsonSerializer)new JsonSerializer<Point>(){

                public void serialize(Point point, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", point.x);
                    jsonGenerator.writeNumberField("Y", point.y);
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(PointF.class, (JsonSerializer)new JsonSerializer<PointF>(){

                public void serialize(PointF pointF, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", pointF.x);
                    jsonGenerator.writeNumberField("Y", pointF.y);
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(RectF.class, (JsonSerializer)new JsonSerializer<RectF>(){

                public void serialize(RectF rectF, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", rectF.right);
                    jsonGenerator.writeNumberField("Y", rectF.top);
                    jsonGenerator.writeNumberField("Width", rectF.width());
                    jsonGenerator.writeNumberField("Height", rectF.height());
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(Bitmap.class, (JsonSerializer)new JsonSerializer<Bitmap>(){

                public void serialize(Bitmap bitmap, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
                    jsonGenerator.writeBinary(byteArrayOutputStream.toByteArray());
                }
            });
        }

        private static void initAndroidDeserializers(SimpleModule simpleModule) {
            simpleModule.addDeserializer(Point.class, (JsonDeserializer)new JsonDeserializer<Point>(){

                public Point deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new Point(jsonNode.get("X").asInt(), jsonNode.get("Y").asInt());
                }
            });
            simpleModule.addDeserializer(PointF.class, (JsonDeserializer)new JsonDeserializer<PointF>(){

                public PointF deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new PointF(jsonNode.get("X").floatValue(), jsonNode.get("Y").floatValue());
                }
            });
            simpleModule.addDeserializer(RectF.class, (JsonDeserializer)new JsonDeserializer<RectF>(){

                public RectF deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    float f = jsonNode.get("X").floatValue();
                    float f2 = jsonNode.get("Y").floatValue();
                    float f3 = jsonNode.get("Width").floatValue();
                    float f4 = jsonNode.get("Height").floatValue();
                    return new RectF(f2, f, f2 + f3, f - f4);
                }
            });
            simpleModule.addDeserializer(Bitmap.class, (JsonDeserializer)new JsonDeserializer<Bitmap>(){

                public Bitmap deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jsonParser.getBinaryValue());
                    return BitmapFactory.decodeStream((InputStream)byteArrayInputStream);
                }
            });
        }
    }

    static class JavaConverters {
        JavaConverters() {
        }

        private static void initJavaSerializers(SimpleModule simpleModule) {
            simpleModule.addSerializer(java.awt.Point.class, (JsonSerializer)new JsonSerializer<java.awt.Point>(){

                public void serialize(java.awt.Point point, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", point.x);
                    jsonGenerator.writeNumberField("Y", point.y);
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(Point2D.class, (JsonSerializer)new JsonSerializer<Point2D>(){

                public void serialize(Point2D point2D, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", point2D.getX());
                    jsonGenerator.writeNumberField("Y", point2D.getY());
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(Rectangle2D.class, (JsonSerializer)new JsonSerializer<Rectangle2D>(){

                public void serialize(Rectangle2D rectangle2D, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    jsonGenerator.writeStartObject();
                    jsonGenerator.writeNumberField("X", rectangle2D.getX());
                    jsonGenerator.writeNumberField("Y", rectangle2D.getY());
                    jsonGenerator.writeNumberField("Width", rectangle2D.getWidth());
                    jsonGenerator.writeNumberField("Height", rectangle2D.getHeight());
                    jsonGenerator.writeEndObject();
                }
            });
            simpleModule.addSerializer(BufferedImage.class, (JsonSerializer)new JsonSerializer<BufferedImage>(){

                public void serialize(BufferedImage bufferedImage, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
                    jsonGenerator.writeBinary(byteArrayOutputStream.toByteArray());
                }
            });
        }

        private static void initJavaDeserializers(SimpleModule simpleModule) {
            simpleModule.addDeserializer(java.awt.Point.class, (JsonDeserializer)new JsonDeserializer<java.awt.Point>(){

                public java.awt.Point deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new java.awt.Point(jsonNode.get("X").asInt(), jsonNode.get("Y").asInt());
                }
            });
            simpleModule.addDeserializer(Point2D.class, (JsonDeserializer)new JsonDeserializer<Point2D>(){

                public Point2D deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new Point2D.Double(jsonNode.get("X").asDouble(), jsonNode.get("Y").asDouble());
                }
            });
            simpleModule.addDeserializer(Rectangle2D.class, (JsonDeserializer)new JsonDeserializer<Rectangle2D>(){

                public Rectangle2D deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
                    return new Rectangle2D.Double(jsonNode.get("X").asDouble(), jsonNode.get("Y").asDouble(), jsonNode.get("Width").asDouble(), jsonNode.get("Height").asDouble());
                }
            });
            simpleModule.addDeserializer(BufferedImage.class, (JsonDeserializer)new JsonDeserializer<BufferedImage>(){

                public BufferedImage deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(jsonParser.getBinaryValue());
                    return ImageIO.read(byteArrayInputStream);
                }
            });
        }
    }
}

