/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.Base64;
import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class BinaryConverter {
    private static JsonReader.ReadObject<byte[]> Base64Reader = new JsonReader.ReadObject<byte[]>(){

        @Override
        public byte[] read(JsonReader jsonReader) throws IOException {
            return BinaryConverter.deserialize(jsonReader);
        }
    };

    public static void serialize(byte[] byArray, Writer writer) throws IOException {
        if (byArray == null) {
            writer.write("null");
        } else if (byArray.length == 0) {
            writer.write("\"\"");
        } else {
            writer.write(34);
            writer.write(Base64.encodeToChar(byArray));
            writer.write(34);
        }
    }

    public static byte[] deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readBase64();
    }

    public static ArrayList<byte[]> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(Base64Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<byte[]> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(Base64Reader, collection);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<byte[]> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(Base64Reader, collection);
    }
}

