/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class BoolConverter {
    private static JsonReader.ReadObject<Boolean> BooleanReader = new JsonReader.ReadObject<Boolean>(){

        @Override
        public Boolean read(JsonReader jsonReader) throws IOException {
            return BoolConverter.deserialize(jsonReader);
        }
    };

    public static void serializeNullable(Boolean bl, Writer writer) throws IOException {
        if (bl == null) {
            writer.write("null");
        } else if (bl.booleanValue()) {
            writer.write("true");
        } else {
            writer.write("false");
        }
    }

    public static void serialize(boolean bl, Writer writer) throws IOException {
        if (bl) {
            writer.write("true");
        } else {
            writer.write("false");
        }
    }

    public static boolean deserialize(JsonReader jsonReader) throws IOException {
        if (jsonReader.wasTrue()) {
            return true;
        }
        if (jsonReader.wasFalse()) {
            return false;
        }
        throw new IOException("Found invalid boolean value at: " + jsonReader.positionInStream());
    }

    public static ArrayList<Boolean> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(BooleanReader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<Boolean> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(BooleanReader, collection);
    }

    public static ArrayList<Boolean> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(BooleanReader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<Boolean> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(BooleanReader, collection);
    }
}

