/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import com.dslplatform.client.json.NumberConverter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class DateConverter {
    public static final DateTime MIN_DATE_TIME = DateTime.parse((String)"0001-01-01T00:00:00Z");
    public static final LocalDate MIN_LOCAL_DATE = new LocalDate(1, 1, 1);
    private static final DateTimeFormatter dateTimeFormat = ISODateTimeFormat.dateTime();
    private static final DateTimeFormatter localDateFormat = ISODateTimeFormat.date();
    private static final DateTimeFormatter localDateParser = ISODateTimeFormat.localDateParser();
    private static JsonReader.ReadObject<DateTime> DateTimeReader = new JsonReader.ReadObject<DateTime>(){

        @Override
        public DateTime read(JsonReader jsonReader) throws IOException {
            return DateConverter.deserializeDateTime(jsonReader);
        }
    };
    private static JsonReader.ReadObject<LocalDate> LocalDateReader = new JsonReader.ReadObject<LocalDate>(){

        @Override
        public LocalDate read(JsonReader jsonReader) throws IOException {
            return DateConverter.deserializeLocalDate(jsonReader);
        }
    };

    public static void serializeNullable(DateTime dateTime, Writer writer) throws IOException {
        if (dateTime == null) {
            writer.write("null");
        } else {
            DateConverter.serialize(dateTime, writer);
        }
    }

    public static void serialize(DateTime dateTime, Writer writer) throws IOException {
        if (DateTimeZone.UTC.equals((Object)dateTime.getZone()) && writer instanceof JsonWriter) {
            DateConverter.serialize(dateTime, (JsonWriter)writer);
        } else {
            writer.write(34);
            dateTimeFormat.printTo(writer, (ReadableInstant)dateTime);
            writer.write(34);
        }
    }

    public static void serialize(DateTime dateTime, JsonWriter jsonWriter) throws IOException {
        char[] cArray = jsonWriter.tmp;
        cArray[0] = 34;
        int n = dateTime.getYear();
        NumberConverter.write2(n / 100, cArray, 1);
        NumberConverter.write2(n, cArray, 3);
        cArray[5] = 45;
        NumberConverter.write2(dateTime.getMonthOfYear(), cArray, 6);
        cArray[8] = 45;
        NumberConverter.write2(dateTime.getDayOfMonth(), cArray, 9);
        cArray[11] = 84;
        NumberConverter.write2(dateTime.getHourOfDay(), cArray, 12);
        cArray[14] = 58;
        NumberConverter.write2(dateTime.getMinuteOfHour(), cArray, 15);
        cArray[17] = 58;
        NumberConverter.write2(dateTime.getSecondOfMinute(), cArray, 18);
        int n2 = dateTime.getMillisOfSecond();
        if (n2 != 0) {
            cArray[20] = 46;
            int n3 = n2 / 100;
            int n4 = n2 - n3 * 100;
            cArray[21] = (char)(n3 + 48);
            if (n4 != 0) {
                NumberConverter.write2(n4, cArray, 22);
                cArray[24] = 90;
                cArray[25] = 34;
                jsonWriter.buffer.append(cArray, 0, 26);
            } else {
                cArray[22] = 90;
                cArray[23] = 34;
                jsonWriter.buffer.append(cArray, 0, 24);
            }
        } else {
            cArray[20] = 90;
            cArray[21] = 34;
            jsonWriter.buffer.append(cArray, 0, 22);
        }
    }

    public static DateTime deserializeDateTime(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readSimpleQuote();
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        if (n > 18 && n < 25 && cArray[n - 1] == 'Z' && cArray[4] == '-' && cArray[7] == '-' && (cArray[10] == 'T' || cArray[10] == 't' || cArray[10] == ' ') && cArray[13] == ':' && cArray[16] == ':') {
            int n2 = NumberConverter.read4(cArray, 0);
            int n3 = NumberConverter.read2(cArray, 5);
            int n4 = NumberConverter.read2(cArray, 8);
            int n5 = NumberConverter.read2(cArray, 11);
            int n6 = NumberConverter.read2(cArray, 14);
            int n7 = NumberConverter.read2(cArray, 17);
            if (cArray[19] == '.') {
                int n8 = NumberConverter.read(cArray, 20, n - 1);
                return new DateTime(n2, n3, n4, n5, n6, n7, n8, DateTimeZone.UTC);
            }
            return new DateTime(n2, n3, n4, n5, n6, n7, 0, DateTimeZone.UTC);
        }
        return DateTime.parse((String)new String(cArray, 0, n));
    }

    public static ArrayList<DateTime> deserializeDateTimeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(DateTimeReader);
    }

    public static void deserializeDateTimeCollection(JsonReader jsonReader, Collection<DateTime> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(DateTimeReader, collection);
    }

    public static ArrayList<DateTime> deserializeDateTimeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(DateTimeReader);
    }

    public static void deserializeDateTimeNullableCollection(JsonReader jsonReader, Collection<DateTime> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(DateTimeReader, collection);
    }

    public static void serializeNullable(LocalDate localDate, Writer writer) throws IOException {
        if (localDate == null) {
            writer.write("null");
        } else {
            DateConverter.serialize(localDate, writer);
        }
    }

    public static void serialize(LocalDate localDate, Writer writer) throws IOException {
        if (writer instanceof JsonWriter) {
            DateConverter.serialize(localDate, (JsonWriter)writer);
        } else {
            writer.write(34);
            localDateFormat.printTo(writer, (ReadablePartial)localDate);
            writer.write(34);
        }
    }

    public static void serialize(LocalDate localDate, JsonWriter jsonWriter) throws IOException {
        char[] cArray = jsonWriter.tmp;
        cArray[0] = 34;
        int n = localDate.getYear();
        NumberConverter.write2(n / 100, cArray, 1);
        NumberConverter.write2(n, cArray, 3);
        cArray[5] = 45;
        NumberConverter.write2(localDate.getMonthOfYear(), cArray, 6);
        cArray[8] = 45;
        NumberConverter.write2(localDate.getDayOfMonth(), cArray, 9);
        cArray[11] = 34;
        jsonWriter.buffer.append(cArray, 0, 12);
    }

    public static LocalDate deserializeLocalDate(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readSimpleQuote();
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        if (n == 10 && cArray[4] == '-' && cArray[7] == '-') {
            int n2 = NumberConverter.read4(cArray, 0);
            int n3 = NumberConverter.read2(cArray, 5);
            int n4 = NumberConverter.read2(cArray, 8);
            return new LocalDate(n2, n3, n4);
        }
        return localDateParser.parseLocalDate(new String(cArray, 0, n));
    }

    public static ArrayList<LocalDate> deserializeLocalDateCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(LocalDateReader);
    }

    public static void deserializeLocalDateCollection(JsonReader jsonReader, Collection<LocalDate> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(LocalDateReader, collection);
    }

    public static ArrayList<LocalDate> deserializeLocalDateNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(LocalDateReader);
    }

    public static void deserializeLocalDateNullableCollection(JsonReader jsonReader, Collection<LocalDate> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(LocalDateReader, collection);
    }
}

