/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import com.dslplatform.client.json.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

public class NumberConverter {
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static JsonReader.ReadObject<Double> DoubleReader = new JsonReader.ReadObject<Double>(){

        @Override
        public Double read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDouble(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Float> FloatReader = new JsonReader.ReadObject<Float>(){

        @Override
        public Float read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeFloat(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Integer> IntReader = new JsonReader.ReadObject<Integer>(){

        @Override
        public Integer read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeInt(jsonReader);
        }
    };
    private static JsonReader.ReadObject<Long> LongReader = new JsonReader.ReadObject<Long>(){

        @Override
        public Long read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeLong(jsonReader);
        }
    };
    private static JsonReader.ReadObject<BigDecimal> DecimalReader = new JsonReader.ReadObject<BigDecimal>(){

        @Override
        public BigDecimal read(JsonReader jsonReader) throws IOException {
            return NumberConverter.deserializeDecimal(jsonReader);
        }
    };

    static void write2(int n, char[] cArray, int n2) throws IOException {
        int n3 = n / 100;
        int n4 = n - ((n3 << 6) + (n3 << 5) + (n3 << 2));
        cArray[n2] = DigitTens[n4];
        cArray[n2 + 1] = DigitOnes[n4];
    }

    static int read2(char[] cArray, int n) {
        return (cArray[n] - 48) * 10 + cArray[n + 1] - 48;
    }

    static int read(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            n3 = n3 * 10 + cArray[i] - 48;
        }
        return n3;
    }

    static int read4(char[] cArray, int n) {
        return (cArray[n] - 48) * 1000 + (cArray[n + 1] - 48) * 100 + (cArray[n + 2] - 48) * 10 + cArray[n + 3] - 48;
    }

    public static void serializeNullable(Double d, Writer writer) throws IOException {
        if (d == null) {
            writer.write("null");
        } else {
            NumberConverter.serialize(d, writer);
        }
    }

    public static void serialize(double d, Writer writer) throws IOException {
        writer.write(Double.toString(d));
    }

    public static Double deserializeDouble(JsonReader jsonReader) throws IOException {
        return Double.parseDouble(jsonReader.readShortValue());
    }

    public static ArrayList<Double> deserializeDoubleCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(DoubleReader);
    }

    public static void deserializeDoubleCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(DoubleReader, collection);
    }

    public static ArrayList<Double> deserializeDoubleNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(DoubleReader);
    }

    public static void deserializeDoubleNullableCollection(JsonReader jsonReader, Collection<Double> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(DoubleReader, collection);
    }

    public static void serializeNullable(Float f, Writer writer) throws IOException {
        if (f == null) {
            writer.write("null");
        } else {
            NumberConverter.serialize(f.floatValue(), writer);
        }
    }

    public static void serialize(float f, Writer writer) throws IOException {
        writer.write(Float.toString(f));
    }

    public static Float deserializeFloat(JsonReader jsonReader) throws IOException {
        return Float.valueOf(Float.parseFloat(jsonReader.readShortValue()));
    }

    public static ArrayList<Float> deserializeFloatCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(FloatReader);
    }

    public static void deserializeFloatCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(FloatReader, collection);
    }

    public static ArrayList<Float> deserializeFloatNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(FloatReader);
    }

    public static void deserializeFloatNullableCollection(JsonReader jsonReader, Collection<Float> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(FloatReader, collection);
    }

    public static void serializeNullable(Integer n, Writer writer) throws IOException {
        if (n == null) {
            writer.write("null");
        } else {
            NumberConverter.serialize((int)n, writer);
        }
    }

    public static void serialize(int n, Writer writer) throws IOException {
        if (n == Integer.MIN_VALUE) {
            writer.write("-2147483648");
        } else if (writer instanceof JsonWriter) {
            NumberConverter.serialize(n, (JsonWriter)writer);
        } else {
            writer.write(Integer.toString(n));
        }
    }

    public static void serialize(int n, JsonWriter jsonWriter) throws IOException {
        int n2;
        int n3 = 10;
        char[] cArray = jsonWriter.tmp;
        StringBuilder stringBuilder = jsonWriter.buffer;
        if (n < 0) {
            n2 = -n;
            stringBuilder.append('-');
        } else {
            n2 = n;
        }
        do {
            int n4 = n2 / 100;
            int n5 = n2 - ((n4 << 6) + (n4 << 5) + (n4 << 2));
            n2 = n4;
            cArray[n3--] = DigitOnes[n5];
            cArray[n3--] = DigitTens[n5];
        } while (n2 != 0);
        int n6 = cArray[n3 + 1] == '0' ? n3 + 2 : n3 + 1;
        stringBuilder.append(cArray, n6, 10 - n6 + 1);
    }

    public static int deserializeInt(JsonReader jsonReader) throws IOException {
        int n;
        char[] cArray = jsonReader.readNumber();
        int n2 = 0;
        int n3 = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        for (int i = n = cArray[0] == '-' ? 1 : 0; i < n3 && i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return Integer.parseInt(new String(cArray, 0, n3));
            }
            n2 = n2 * 10 + c - 48;
        }
        return n == 0 ? n2 : -n2;
    }

    public static ArrayList<Integer> deserializeIntCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(IntReader);
    }

    public static void deserializeIntCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(IntReader, collection);
    }

    public static ArrayList<Integer> deserializeIntNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(IntReader);
    }

    public static void deserializeIntNullableCollection(JsonReader jsonReader, Collection<Integer> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(IntReader, collection);
    }

    public static void serializeNullable(Long l, Writer writer) throws IOException {
        if (l == null) {
            writer.write("null");
        } else {
            NumberConverter.serialize((long)l, writer);
        }
    }

    public static void serialize(long l, Writer writer) throws IOException {
        if (l == Long.MIN_VALUE) {
            writer.write("-9223372036854775808");
        } else if (writer instanceof JsonWriter) {
            NumberConverter.serialize(l, (JsonWriter)writer);
        } else {
            writer.write(Long.toString(l));
        }
    }

    public static void serialize(long l, JsonWriter jsonWriter) throws IOException {
        long l2;
        int n = 20;
        char[] cArray = jsonWriter.tmp;
        StringBuilder stringBuilder = jsonWriter.buffer;
        if (l < 0L) {
            l2 = -l;
            stringBuilder.append('-');
        } else {
            l2 = l;
        }
        do {
            long l3 = l2 / 100L;
            int n2 = (int)(l2 - ((l3 << 6) + (l3 << 5) + (l3 << 2)));
            l2 = l3;
            cArray[n--] = DigitOnes[n2];
            cArray[n--] = DigitTens[n2];
        } while (l2 != 0L);
        int n3 = cArray[n + 1] == '0' ? n + 2 : n + 1;
        stringBuilder.append(cArray, n3, 20 - n3 + 1);
    }

    public static long deserializeLong(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        long l = 0L;
        int n = jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1;
        boolean bl = cArray[0] == '-';
        for (int i = 0; i < n && i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return Long.parseLong(new String(cArray, 0, n));
            }
            l = l * 10L + (long)c - 48L;
        }
        return !bl ? l : -l;
    }

    public static ArrayList<Long> deserializeLongCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(LongReader);
    }

    public static void deserializeLongCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(LongReader, collection);
    }

    public static ArrayList<Long> deserializeLongNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(LongReader);
    }

    public static void deserializeLongNullableCollection(JsonReader jsonReader, Collection<Long> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(LongReader, collection);
    }

    public static void serializeNullable(BigDecimal bigDecimal, Writer writer) throws IOException {
        if (bigDecimal == null) {
            writer.write("null");
        } else {
            writer.write(bigDecimal.toString());
        }
    }

    public static void serialize(BigDecimal bigDecimal, Writer writer) throws IOException {
        writer.write(bigDecimal.toString());
    }

    public static BigDecimal deserializeDecimal(JsonReader jsonReader) throws IOException {
        char[] cArray = jsonReader.readNumber();
        return new BigDecimal(cArray, 0, jsonReader.getCurrentIndex() - jsonReader.getTokenStart() - 1);
    }

    public static ArrayList<BigDecimal> deserializeDecimalCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithMove(DecimalReader);
    }

    public static void deserializeDecimalCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeCollectionWithMove(DecimalReader, collection);
    }

    public static ArrayList<BigDecimal> deserializeDecimalNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithMove(DecimalReader);
    }

    public static void deserializeDecimalNullableCollection(JsonReader jsonReader, Collection<BigDecimal> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithMove(DecimalReader, collection);
    }
}

