/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.client.json;

import com.dslplatform.client.json.JsonReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;

public class StringConverter {
    private static JsonReader.ReadObject<String> Reader = new JsonReader.ReadObject<String>(){

        @Override
        public String read(JsonReader jsonReader) throws IOException {
            return StringConverter.deserialize(jsonReader);
        }
    };

    public static void serializeNullable(String string, Writer writer) throws IOException {
        if (string == null) {
            writer.write("null");
        } else {
            StringConverter.serialize(string, writer);
        }
    }

    public static void serialize(String string, Writer writer) throws IOException {
        char c;
        int n;
        writer.write(34);
        for (n = 0; n < string.length() && (c = string.charAt(n)) >= ' ' && c != '\"' && c != '\\'; ++n) {
        }
        writer.write(string, 0, n);
        while (n < string.length()) {
            c = string.charAt(n);
            switch (c) {
                case '\u0000': {
                    writer.write("\\u0000");
                    break;
                }
                case '\u0001': {
                    writer.write("\\u0001");
                    break;
                }
                case '\u0002': {
                    writer.write("\\u0002");
                    break;
                }
                case '\u0003': {
                    writer.write("\\u0003");
                    break;
                }
                case '\u0004': {
                    writer.write("\\u0004");
                    break;
                }
                case '\u0005': {
                    writer.write("\\u0005");
                    break;
                }
                case '\u0006': {
                    writer.write("\\u0006");
                    break;
                }
                case '\u0007': {
                    writer.write("\\u0007");
                    break;
                }
                case '\b': {
                    writer.write("\\b");
                    break;
                }
                case '\t': {
                    writer.write("\\t");
                    break;
                }
                case '\n': {
                    writer.write("\\n");
                    break;
                }
                case '\u000b': {
                    writer.write("\\u000B");
                    break;
                }
                case '\f': {
                    writer.write("\\f");
                    break;
                }
                case '\r': {
                    writer.write("\\r");
                    break;
                }
                case '\u000e': {
                    writer.write("\\u000E");
                    break;
                }
                case '\u000f': {
                    writer.write("\\u000F");
                    break;
                }
                case '\u0010': {
                    writer.write("\\u0010");
                    break;
                }
                case '\u0011': {
                    writer.write("\\u0011");
                    break;
                }
                case '\u0012': {
                    writer.write("\\u0012");
                    break;
                }
                case '\u0013': {
                    writer.write("\\u0013");
                    break;
                }
                case '\u0014': {
                    writer.write("\\u0014");
                    break;
                }
                case '\u0015': {
                    writer.write("\\u0015");
                    break;
                }
                case '\u0016': {
                    writer.write("\\u0016");
                    break;
                }
                case '\u0017': {
                    writer.write("\\u0017");
                    break;
                }
                case '\u0018': {
                    writer.write("\\u0018");
                    break;
                }
                case '\u0019': {
                    writer.write("\\u0019");
                    break;
                }
                case '\u001a': {
                    writer.write("\\u001A");
                    break;
                }
                case '\u001b': {
                    writer.write("\\u001B");
                    break;
                }
                case '\u001c': {
                    writer.write("\\u001C");
                    break;
                }
                case '\u001d': {
                    writer.write("\\u001D");
                    break;
                }
                case '\u001e': {
                    writer.write("\\u001E");
                    break;
                }
                case '\u001f': {
                    writer.write("\\u001F");
                    break;
                }
                case '\\': {
                    writer.write("\\\\");
                    break;
                }
                case '\"': {
                    writer.write("\\\"");
                    break;
                }
                default: {
                    writer.write(c);
                }
            }
            ++n;
        }
        writer.write(34);
    }

    public static String deserialize(JsonReader jsonReader) throws IOException {
        return jsonReader.readString();
    }

    public static String deserializeNullable(JsonReader jsonReader) throws IOException {
        if (jsonReader.last() == 110) {
            if (!jsonReader.wasNull()) {
                throw new IOException("Expecting 'null' at position " + jsonReader.positionInStream() + ". Found " + (char)jsonReader.last());
            }
            return null;
        }
        return jsonReader.readString();
    }

    public static ArrayList<String> deserializeCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeCollectionWithGet(Reader);
    }

    public static void deserializeCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeCollectionWithGet(Reader, collection);
    }

    public static ArrayList<String> deserializeNullableCollection(JsonReader jsonReader) throws IOException {
        return jsonReader.deserializeNullableCollectionWithGet(Reader);
    }

    public static void deserializeNullableCollection(JsonReader jsonReader, Collection<String> collection) throws IOException {
        jsonReader.deserializeNullableCollectionWithGet(Reader, collection);
    }
}

